/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.charts.xy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.TimedEvent;
import nl.tudelft.simulation.language.filters.Filterinterface;
import nl.tudelft.simulation.language.filters.ZeroFilter;
import nl.tudelft.simulation.logger.Logger;
import org.jfree.data.AbstractDataset;

public class XYSeries
extends AbstractDataset
implements EventListenerInterface {
    public static final EventType LOWER_RANGE_EVENT = new EventType("LOWER_RANGE_EVENT");
    public static final EventType UPPER_RANGE_EVENT = new EventType("UPPER_RANGE_EVENT");
    private String name = null;
    protected List entries = new ArrayList();
    private short axisType = 0;
    private Filterinterface filter = new ZeroFilter();
    private final double PERIOD;

    public XYSeries(String name, short axisType, double period) {
        new ArrayList();
        this.axisType = axisType;
        this.name = name;
        this.PERIOD = period;
        this.fireDatasetChanged();
    }

    public synchronized void notify(EventInterface event) {
        TimedEvent timedEvent = (TimedEvent)event;
        if ((this.axisType == 2 || this.axisType == 3) && timedEvent.getTimeStamp() <= 0.0) {
            Logger.warning((Object)this, (String)"notify", (String)("refusing xvalue of " + event + " on logrithmic chart"));
            return;
        }
        if ((this.axisType == 1 || this.axisType == 3) && ((Number)timedEvent.getContent()).doubleValue() <= 0.0) {
            Logger.warning((Object)this, (String)"notify", (String)("refusing yValue of " + event + " on logrithmic chart"));
            return;
        }
        double[] point = new double[]{timedEvent.getTimeStamp(), ((Number)timedEvent.getContent()).doubleValue()};
        if (!this.filter.accept((Object)point)) {
            return;
        }
        this.entries.add(point);
        if (!Double.isInfinite(this.PERIOD)) {
            double[] entry;
            double lowerBounds = point[0] - this.PERIOD;
            Iterator i = this.entries.iterator();
            while (i.hasNext() && (entry = (double[])i.next())[0] < lowerBounds) {
                i.remove();
            }
        }
        this.fireDatasetChanged();
    }

    public int getItemCount() {
        return this.entries.size();
    }

    public synchronized Number getXValue(int item) {
        item = Math.min(item, this.entries.size() - 1);
        return new Double(((double[])this.entries.get(item))[0]);
    }

    public Number getYValue(int item) {
        item = Math.min(item, this.entries.size() - 1);
        return new Double(((double[])this.entries.get(item))[1]);
    }

    public String getSeriesName() {
        return this.name;
    }

    public void setFilter(Filterinterface filter) {
        this.filter = filter;
    }
}

