/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.distributions.empirical.Observations;
import nl.tudelft.simulation.jstats.distributions.empirical.ObservationsInterface;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistDiscreteEmpirical
extends DistDiscrete {
    private ObservationsInterface observations = null;

    public DistDiscreteEmpirical(StreamInterface stream, ObservationsInterface observations) {
        super(stream);
        this.observations = !observations.isGrouped() ? new Observations(DistDiscreteEmpirical.constructGroupedMap(observations.getObservations()), false) : observations;
    }

    public DistDiscreteEmpirical(StreamInterface stream, Long[] observations) {
        super(stream);
        this.observations = new Observations(DistDiscreteEmpirical.constructGroupedMap(Arrays.asList(observations)), false);
    }

    public DistDiscreteEmpirical(StreamInterface stream, long[] observations) {
        super(stream);
        Long[] values = new Long[observations.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new Long(observations[i]);
        }
        this.observations = new Observations(DistDiscreteEmpirical.constructGroupedMap(Arrays.asList(values)), false);
    }

    public DistDiscreteEmpirical(StreamInterface stream, SortedMap observations, boolean cummulative) {
        super(stream);
        this.observations = new Observations(observations, cummulative);
    }

    public long draw() {
        double u = this.stream.nextDouble();
        return this.observations.getCeilingEntry(new Double(u), (byte)1, true).getObservation().longValue();
    }

    public double probability(int observation) {
        if (this.observations.contains(new Long(observation), (byte)0)) {
            int index = this.observations.getIndex(this.observations.getEntry(new Long(observation), (byte)0));
            if (index > 0) {
                return this.observations.get(index).getCumProbability() - this.observations.get(index - 1).getCumProbability();
            }
            return this.observations.get(index).getCumProbability();
        }
        return 0.0;
    }

    private static SortedMap constructGroupedMap(List observations) {
        TreeMap result = new TreeMap();
        Iterator i = observations.iterator();
        while (i.hasNext()) {
            Object entry = i.next();
            if (result.containsKey(entry)) {
                Number value = (Number)result.get(entry);
                result.put(entry, new Double(value.doubleValue() + 1.0));
                continue;
            }
            result.put(entry, new Double(1.0));
        }
        return result;
    }
}

