/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import java.util.List;
import java.util.SortedMap;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.empirical.Observations;
import nl.tudelft.simulation.jstats.distributions.empirical.ObservationsInterface;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistEmpirical
extends DistContinuous {
    private ObservationsInterface observations = null;

    public DistEmpirical(StreamInterface stream, ObservationsInterface observations) {
        super(stream);
        this.observations = observations;
    }

    public DistEmpirical(StreamInterface stream, Double[] observations) {
        super(stream);
        this.observations = new Observations(observations);
    }

    public DistEmpirical(StreamInterface stream, List observations) {
        this(stream, observations.toArray(new Double[observations.size()]));
    }

    public DistEmpirical(StreamInterface stream, SortedMap observations, boolean cummulative) {
        super(stream);
        this.observations = new Observations(observations, cummulative);
    }

    public double draw() {
        if (this.observations.isGrouped()) {
            return this.drawGrouped();
        }
        return this.drawNonGrouped();
    }

    private double drawGrouped() {
        double u = this.stream.nextDouble();
        ObservationsInterface.Entry p = this.observations.getPrecedingEntry(new Double(u), (byte)1, true);
        int j = this.observations.getIndex(p);
        ObservationsInterface.Entry q = this.observations.get(j + 1);
        double result = p.getObservation().doubleValue();
        return result += (u - p.getCumProbability()) * (q.getObservation().doubleValue() - p.getObservation().doubleValue()) / (q.getCumProbability() - p.getCumProbability());
    }

    private double drawNonGrouped() {
        double u = this.stream.nextDouble();
        double p = (double)(this.observations.size() - 1) * u;
        int i = (int)(Math.floor(p) + 1.0);
        double xi = this.observations.get(i - 1).getObservation().doubleValue();
        return xi + (p - (double)i + 1.0) * (this.observations.get(i).getObservation().doubleValue() - xi);
    }

    public double probDensity(double observation) {
        if (observation < this.observations.get(0).getObservation().doubleValue()) {
            return 0.0;
        }
        if (this.observations.get(this.observations.size() - 1).getObservation().doubleValue() <= observation) {
            return 1.0;
        }
        if (this.observations.isGrouped()) {
            return this.probDensityGrouped(observation);
        }
        return this.probDensityNonGrouped(observation);
    }

    private double probDensityGrouped(double observation) {
        ObservationsInterface.Entry p = this.observations.getPrecedingEntry(new Double(observation), (byte)0, true);
        int j = this.observations.getIndex(p);
        ObservationsInterface.Entry q = this.observations.get(j + 1);
        return p.getCumProbability() + (observation - p.getObservation().doubleValue()) / (q.getObservation().doubleValue() - p.getObservation().doubleValue()) * (q.getCumProbability() - p.getCumProbability());
    }

    private double probDensityNonGrouped(double observation) {
        ObservationsInterface.Entry p = this.observations.getPrecedingEntry(new Double(observation), (byte)0, true);
        int i = this.observations.getIndex(p) + 1;
        ObservationsInterface.Entry q = this.observations.get(i);
        return (double)(i - 1) / (double)(this.observations.size() - 1) + (observation - p.getObservation().doubleValue()) / ((double)(this.observations.size() - 1) * (q.getObservation().doubleValue() - p.getObservation().doubleValue()));
    }
}

