/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import cern.jet.stat.Gamma;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistGamma
extends DistContinuous {
    private double alpha;
    private double beta;

    public DistGamma(StreamInterface stream, double alpha, double beta) {
        super(stream);
        if (!(alpha > 0.0) || !(beta > 0.0)) {
            throw new IllegalArgumentException("Error Gamma - alpha <= 0.0 or beta <= 0.0");
        }
        this.alpha = alpha;
        this.beta = beta;
    }

    public double draw() {
        if (this.alpha < 1.0) {
            double b = (Math.E + this.alpha) / Math.E;
            long counter = 0L;
            while (counter < 1000L) {
                double u2;
                double y;
                double p = b * this.stream.nextDouble();
                if (p <= 1.0) {
                    y = Math.pow(p, 1.0 / this.alpha);
                    u2 = this.stream.nextDouble();
                    if (!(u2 <= Math.exp(-y))) continue;
                    return this.beta * y;
                }
                y = -Math.log((b - p) / this.alpha);
                u2 = this.stream.nextDouble();
                if (!(u2 <= Math.pow(y, this.alpha - 1.0))) continue;
                return this.beta * y;
            }
            new IllegalArgumentException("1000 tries for alpha<1.0");
            return 1.0;
        }
        if (this.alpha > 1.0) {
            double a = 1.0 / Math.sqrt(2.0 * this.alpha - 1.0);
            double b = this.alpha - Math.log(4.0);
            double q = this.alpha + 1.0 / a;
            double theta = 4.5;
            double d = 1.0 + Math.log(theta);
            long counter = 0L;
            while (counter < 1000L) {
                double z;
                double y;
                double u1 = this.stream.nextDouble();
                double u2 = this.stream.nextDouble();
                double v = a * Math.log(u1 / (1.0 - u1));
                double w = b + q * v - (y = this.alpha * Math.exp(v));
                if (w + d - theta * (z = u1 * u1 * u2) >= 0.0) {
                    return this.beta * y;
                }
                if (!(w > Math.log(z))) continue;
                return this.beta * y;
            }
            new IllegalArgumentException("1000 tries for alpha>1.0");
            return 1.0;
        }
        return -this.beta * Math.log(this.stream.nextDouble());
    }

    public double probDensity(double observation) {
        if (observation <= 0.0) {
            return 0.0;
        }
        return Math.pow(this.beta, -this.alpha) * Math.pow(observation, this.alpha - 1.0) * Math.exp(-1.0 * observation / this.beta) / Gamma.gamma(this.alpha);
    }

    public String toString() {
        return "Gamma(" + this.alpha + "," + this.beta + ")";
    }
}

