/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import cern.jet.stat.Gamma;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistGamma;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistPearson6
extends DistContinuous {
    private DistGamma dist1;
    private DistGamma dist2;
    private double alpha1;
    private double alpha2;
    private double beta;

    public DistPearson6(StreamInterface stream, double alpha1, double alpha2, double beta) {
        super(stream);
        if (!(alpha1 > 0.0 && alpha2 > 0.0 && beta > 0.0)) {
            throw new IllegalArgumentException("Error alpha1 <= 0.0 or alpha2 <= 0.0 or beta <= 0.0");
        }
        this.alpha1 = alpha1;
        this.alpha2 = alpha2;
        this.beta = beta;
        this.dist1 = new DistGamma(this.stream, this.alpha1, this.beta);
        this.dist2 = new DistGamma(this.stream, this.alpha2, this.beta);
    }

    public double draw() {
        return this.dist1.draw() / this.dist2.draw();
    }

    public double probDensity(double observation) {
        if (observation > 0.0) {
            return Math.pow(observation / this.beta, this.alpha1 - 1.0) / (this.beta * Gamma.beta(this.alpha1, this.alpha2) * Math.pow(1.0 + observation / this.beta, this.alpha1 + this.alpha2));
        }
        return 0.0;
    }

    public String toString() {
        return "Pesrson6(" + this.alpha1 + "," + this.alpha2 + "," + this.beta + ")";
    }
}

