/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistUniform
extends DistContinuous {
    private double a;
    private double b;

    public DistUniform(StreamInterface stream, double a, double b) {
        super(stream);
        this.a = a;
        if (!(b > a)) {
            throw new IllegalArgumentException("Error Uniform - a >= b");
        }
        this.b = b;
    }

    public double draw() {
        return this.a + (this.b - this.a) * this.stream.nextDouble();
    }

    public double probDensity(double observation) {
        if (observation >= this.a && observation <= this.b) {
            return 1.0 / (this.b - this.a);
        }
        return 0.0;
    }

    public String toString() {
        return "Uniform(" + this.a + "," + this.b + ")";
    }
}

