/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions.empirical;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import nl.tudelft.simulation.jstats.distributions.empirical.ObservationsInterface;

public class Observations
implements ObservationsInterface {
    private Number[][] data = null;
    private boolean grouped = false;

    public Observations(Number[] observations) {
        Arrays.sort(observations);
        double probability = 1.0 / (double)observations.length;
        this.data = new Number[2][observations.length];
        for (int i = 0; i < observations.length; ++i) {
            this.data[0][i] = observations[i];
            this.data[1][i] = new Double((double)(i + 1) * probability);
        }
        this.grouped = false;
    }

    public Observations(SortedMap observations, boolean cummulative) {
        this.data = new Number[2][observations.size()];
        int counter = 0;
        Iterator i = observations.keySet().iterator();
        while (i.hasNext()) {
            Number key;
            this.data[0][counter] = key = (Number)i.next();
            this.data[1][counter] = (Double)observations.get(key);
            ++counter;
        }
        this.normalize();
        if (!cummulative) {
            this.makeCummulative();
        }
        this.grouped = true;
    }

    public Observations(Number[][] observations, boolean cummulative) {
        this.data = new Number[2][observations.length];
        for (int i = 0; i < observations.length; ++i) {
            this.data[0][i] = observations[i][0];
            this.data[1][i] = observations[i][1];
        }
        this.normalize();
        if (!cummulative) {
            this.makeCummulative();
        }
        this.grouped = true;
    }

    public int size() {
        return this.data[0].length;
    }

    public boolean isEmpty() {
        if (this.data == null) {
            return true;
        }
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                if (this.data[i][j] == null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public int getIndex(ObservationsInterface.Entry entry) {
        int index = this.getIndex(entry.getObservation(), (byte)0);
        if (index == this.getIndex(entry.getCumProbability(), (byte)1)) {
            return index;
        }
        return -1;
    }

    public List getCumProbabilities() {
        return Arrays.asList(this.data[1]);
    }

    public List getObservations() {
        return Arrays.asList(this.data[0]);
    }

    public boolean contains(Number object, byte type) {
        return this.getIndex(object, type) > -1;
    }

    public ObservationsInterface.Entry getEntry(Number object, byte type) {
        int index = this.getIndex(object, type);
        return this.get(index);
    }

    public ObservationsInterface.Entry getPrecedingEntry(Number object, byte type, boolean inclusive) {
        int index = -1;
        if (inclusive && (index = this.getIndex(object, type)) > -1) {
            return this.get(index);
        }
        return this.get(this.getPrecedingIndex(object, type));
    }

    public ObservationsInterface.Entry getCeilingEntry(Number object, byte type, boolean inclusive) {
        int index = this.getIndex(object, type);
        if (inclusive && index > -1) {
            return this.get(index);
        }
        int precedingIndex = this.getPrecedingIndex(object, type);
        if (precedingIndex < 0) {
            if (object.doubleValue() < this.data[type][0].doubleValue()) {
                return this.get(0);
            }
            return null;
        }
        if (index > -1) {
            return this.get(2 + precedingIndex);
        }
        return this.get(1 + precedingIndex);
    }

    public ObservationsInterface.Entry get(int index) {
        if (index < 0 || index >= this.data[0].length) {
            return null;
        }
        return new Observation(this.data[0][index], (Double)this.data[1][index]);
    }

    protected int getIndex(Number object, byte type) {
        return Arrays.binarySearch(this.data[type], object);
    }

    protected int getPrecedingIndex(Number object, byte type) {
        if (object.doubleValue() <= this.data[type][0].doubleValue()) {
            return -1;
        }
        if (this.data[type][this.size() - 1].doubleValue() <= object.doubleValue()) {
            return -1;
        }
        int index = (int)Math.ceil((double)this.size() / 2.0);
        double stepSize = index;
        while (true) {
            stepSize = 0.5 * stepSize;
            if (this.data[type][index].doubleValue() < object.doubleValue() && this.data[type][index + 1].doubleValue() >= object.doubleValue()) {
                return index;
            }
            if (this.data[type][index].doubleValue() >= object.doubleValue()) {
                index = (int)Math.floor((double)index - stepSize);
                continue;
            }
            index = (int)Math.ceil((double)index + stepSize);
        }
    }

    private void normalize() {
        int i;
        if (this.data[0].length <= 1) {
            return;
        }
        double sum = 0.0;
        boolean toBeConverted = false;
        for (i = 0; i < this.data[1].length; ++i) {
            if (!toBeConverted && this.data[1][i].doubleValue() >= 1.0) {
                toBeConverted = true;
            }
            sum += this.data[1][i].doubleValue();
        }
        if (!toBeConverted) {
            return;
        }
        for (i = 0; i < this.data[1].length; ++i) {
            this.data[1][i] = new Double(this.data[1][i].doubleValue() / sum);
        }
    }

    private void makeCummulative() {
        double value = 0.0;
        for (int i = 0; i < this.data[1].length; ++i) {
            this.data[1][i] = new Double(value += this.data[1][i].doubleValue());
        }
    }

    public String toString() {
        String result = "DistDiscreteEmpirical[\n";
        for (int i = 0; i < this.data[0].length; ++i) {
            result = result + "(" + this.data[0][i] + ";" + this.data[1][i] + ")\n";
        }
        return result;
    }

    public class Observation
    implements ObservationsInterface.Entry {
        private Number observation = null;
        private Double cumProbability = null;

        public Observation(Number observation, Double cumProbability) {
            this.observation = observation;
            this.cumProbability = cumProbability;
        }

        public Double getCumProbability() {
            return this.cumProbability;
        }

        public Number getObservation() {
            return this.observation;
        }
    }
}

