/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.ode.integrators;

import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;

public class RungeKutta4
extends NumericalIntegrator {
    public RungeKutta4(double timeStep, DifferentialEquationInterface equation) {
        super(timeStep, equation);
    }

    public double[] next(double x, double[] y) {
        double[] k1 = this.equation.dy(x, y);
        double[] k2 = this.equation.dy(x + 0.5 * this.timeStep, super.add(y, super.multiply(0.5 * this.timeStep, k1)));
        double[] k3 = this.equation.dy(x + 0.5 * this.timeStep, super.add(y, super.multiply(0.5 * this.timeStep, k2)));
        double[] k4 = this.equation.dy(x + this.timeStep, super.add(y, super.multiply(this.timeStep, k3)));
        double[] sum = super.add(k1, super.multiply(2.0, k2), super.multiply(2.0, k3), k4);
        return super.add(y, super.multiply(this.timeStep / 6.0, sum));
    }
}

