/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.streams;

import nl.tudelft.simulation.jstats.streams.RandomNumberGenerator;

public class MersenneTwister
extends RandomNumberGenerator {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private static final int UMASK = Integer.MAX_VALUE;
    private int[] mt;
    private int mti;
    private int[] mag01;

    public MersenneTwister() {
        this(System.currentTimeMillis());
    }

    public MersenneTwister(long seed) {
        super(seed);
    }

    private void initialize() {
        this.mt = new int[624];
        this.mt[0] = (int)this.seed & Integer.MAX_VALUE;
        if (this.mt[0] == 0) {
            this.setSeed(System.currentTimeMillis());
        }
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 69069 * this.mt[this.mti - 1];
            ++this.mti;
        }
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    protected synchronized long next(int bits) {
        int y;
        if (bits < 0 || bits > 64) {
            throw new IllegalArgumentException("bits (" + bits + ") not in range [0,64]");
        }
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (bits <= 32) {
            return y >>> 32 - bits;
        }
        return y << (int)(32L + this.next(bits - 32));
    }

    public synchronized void setSeed(long seed) {
        this.seed = seed;
        this.initialize();
    }
}

