/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.logger.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractXMLParser {
    private boolean validateSchema;
    private URL url;
    private URL schema;
    private String schemaNamespace;

    public AbstractXMLParser(URL url, URL schema, String schemaNamespace, boolean validateSchema) {
        this.validateSchema = validateSchema;
        this.url = url;
        this.schema = schema;
        this.schemaNamespace = schemaNamespace;
    }

    protected Element parse() throws Exception {
        if (this.validateSchema) {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setErrorHandler(new ValidHandler());
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setEntityResolver(new RelativePathResolver());
            parser.setErrorHandler(new ValidHandler());
            parser.parse(this.schema.toExternalForm());
        }
        DOMParser domParser = new DOMParser();
        domParser.setFeature("http://xml.org/sax/features/validation", true);
        domParser.setFeature("http://apache.org/xml/features/validation/schema", true);
        domParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)(String.valueOf(this.schemaNamespace) + " " + this.schema.toExternalForm()));
        domParser.setEntityResolver((EntityResolver)new RelativePathResolver());
        domParser.setErrorHandler((ErrorHandler)new ValidHandler());
        domParser.parse(this.url.toExternalForm());
        org.w3c.dom.Document document = domParser.getDocument();
        DOMBuilder builder = new DOMBuilder();
        Document jdomDocument = builder.build(document);
        Element xmlRootElement = jdomDocument.getRootElement();
        return xmlRootElement;
    }

    protected abstract void parse(Element var1) throws Exception;

    private static class ValidHandler
    implements ErrorHandler {
        ValidHandler() {
        }

        private String formatError(SAXParseException exception) {
            return "SAXParseException: \nsystemId=" + exception.getSystemId() + "\npublicId=" + exception.getSystemId() + "\nMessage=" + exception.getMessage() + "\nline,col=" + exception.getLineNumber() + "," + exception.getColumnNumber();
        }

        public void warning(SAXParseException exception) {
            Logger.warning((Object)this, (String)this.formatError(exception), (Throwable)exception);
        }

        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(this.formatError(e));
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(this.formatError(e));
        }
    }

    private static class RelativePathResolver
    implements EntityResolver2 {
        private DefaultHandler2 defaultHandler2 = new DefaultHandler2();

        RelativePathResolver() {
        }

        public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
            return this.defaultHandler2.getExternalSubset(name, baseURI);
        }

        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            return this.defaultHandler2.resolveEntity(name, publicId, baseURI, systemId);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            URL url = systemId.startsWith("file:") ? URLResource.getResource((String)systemId.substring(5)) : URLResource.getResource((String)systemId);
            InputStream localStream = URLResource.getResourceAsStream((String)url.toExternalForm());
            if (localStream != null) {
                return new InputSource(localStream);
            }
            return this.defaultHandler2.resolveEntity(publicId, systemId);
        }
    }
}

