/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.xml.dsol;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.experiment.RunControl;
import nl.tudelft.simulation.dsol.experiment.TimeUnitInterface;
import nl.tudelft.simulation.dsol.experiment.Treatment;
import nl.tudelft.simulation.jstats.streams.Java2Random;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.logger.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ExperimentParser {
    private static SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
    static /* synthetic */ Class class$0;

    static {
        builder.setFeature("http://xml.org/sax/features/validation", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        String xsd = URLResource.getResource((String)"/xsd/experiment.xsd").toExternalForm();
        builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://www.simulation.tudelft.nl " + xsd));
    }

    protected ExperimentParser() {
    }

    public static Experiment parseExperiment(URL input) throws IOException {
        if (input == null) {
            throw new IOException("experiment URL=null");
        }
        try {
            Element modelElement;
            ClassLoader loader = ExperimentParser.resolveClassLoader(input);
            Element rootElement = builder.build(input).getRootElement();
            Experiment experiment = new Experiment();
            if (rootElement.getChild("name") != null) {
                experiment.setProperty("EXPERIMENT_NAME", rootElement.getChildText("name"));
            }
            if (rootElement.getChild("analyst") != null) {
                experiment.setProperty("EXPERIMENT_ANALYST", rootElement.getChildText("analyst"));
            }
            if ((modelElement = rootElement.getChild("model")).getChild("class-path") != null) {
                List jarFiles = modelElement.getChild("class-path").getChildren("jar-file");
                URL[] urls = new URL[jarFiles.size()];
                int nr = 0;
                Iterator i = jarFiles.iterator();
                while (i.hasNext()) {
                    Element child = (Element)i.next();
                    urls[nr] = URLResource.getResource((String)child.getValue());
                    ++nr;
                }
                loader = new URLClassLoader(urls, loader);
            }
            Thread.currentThread().setContextClassLoader(loader);
            experiment.setUrl(input);
            Class<?> modelClass = Class.forName(modelElement.getChildText("model-class"), true, loader);
            ModelInterface model = (ModelInterface)ClassUtil.resolveConstructor(modelClass, null).newInstance(null);
            experiment.setModel(model);
            List treatmentList = rootElement.getChildren("treatment");
            int number = 0;
            ArrayList<Treatment> treatmentArray = new ArrayList<Treatment>();
            Iterator i = treatmentList.iterator();
            while (i.hasNext()) {
                Treatment treatment = ExperimentParser.parseTreatment((Element)i.next(), experiment, number);
                ++number;
                treatmentArray.add(treatment);
            }
            Treatment[] treatments = new Treatment[treatmentArray.size()];
            experiment.setTreatments(treatmentArray.toArray(treatments));
            return experiment;
        }
        catch (Exception exception) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("nl.tudelft.simulation.xml.dsol.ExperimentParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.warning((Object)clazz, (String)"parseExperiment", (Throwable)exception);
            throw new IOException(exception.getMessage());
        }
    }

    private static ClassLoader resolveClassLoader(URL input) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (input.getProtocol().equals("file")) {
            try {
                ArrayList<URL> urls = new ArrayList<URL>();
                String path = String.valueOf(input.getPath().substring(0, input.getPath().lastIndexOf(47))) + "/";
                urls.add(new URL("file:" + path));
                if (path.endsWith("src/")) {
                    path = String.valueOf(path.substring(0, path.length() - 4)) + "bin/";
                    urls.add(new URL("file:" + path));
                } else {
                    path = String.valueOf(path.substring(0, path.length())) + "bin/";
                    urls.add(new URL("file:" + path));
                }
                URL[] urlArray = urls.toArray(new URL[urls.size()]);
                URLClassLoader urlClassLoader = new URLClassLoader(urlArray, loader);
                return urlClassLoader;
            }
            catch (MalformedURLException exception) {
                return loader;
            }
        }
        return loader;
    }

    private static long parseDateTime(String value) {
        Calendar calendar = Calendar.getInstance();
        String concatDate = value.split("T")[0];
        String concatTime = value.split("T")[1];
        String[] date = concatDate.split("-");
        String[] time = concatTime.split(":");
        calendar.set(new Integer(date[0]), new Integer(date[1]) - 1, new Integer(date[2]), new Integer(time[0]), new Integer(time[1]), new Integer(time[2]));
        return calendar.getTimeInMillis();
    }

    private static double parsePeriod(Element element, TimeUnitInterface treatmentTimeUnit) throws Exception {
        TimeUnitInterface timeUnit = ExperimentParser.parseTimeUnit(element.getAttribute("unit").getValue());
        double value = -1.0;
        value = element.getText().equals("INF") ? Double.MAX_VALUE : new Double(element.getText());
        if (value < 0.0) {
            throw new JDOMException("parsePeriod: value = " + value + " <0. simulator cannot schedule in past");
        }
        return (double)timeUnit.getValue() * value / (double)treatmentTimeUnit.getValue();
    }

    private static Replication parseReplication(Element element, RunControl parent, int number) throws Exception {
        Replication replication = new Replication(parent, number);
        if (element.getAttribute("description") != null) {
            replication.setDescription(element.getAttribute("description").getValue());
        }
        HashMap<String, Java2Random> streams = new HashMap<String, Java2Random>();
        List streamElements = element.getChildren("stream");
        Iterator i = streamElements.iterator();
        while (i.hasNext()) {
            Element streamElement = (Element)i.next();
            long seed = new Long(streamElement.getAttributeValue("seed"));
            Java2Random stream = new Java2Random(seed);
            streams.put(streamElement.getAttributeValue("name"), stream);
        }
        replication.setStreams(streams);
        return replication;
    }

    private static Properties parseProperties(Element element) {
        Properties result = new Properties();
        List children = element.getChildren("property");
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            String key = child.getAttributeValue("key");
            String value = child.getAttributeValue("value");
            result.put(key, value);
        }
        return result;
    }

    private static RunControl parseRunControl(Element element, Treatment parent) throws Exception {
        RunControl runControl = new RunControl(parent);
        if (element.getChild("warmupPeriod") != null) {
            runControl.setWarmupPeriod(ExperimentParser.parsePeriod(element.getChild("warmupPeriod"), parent.getTimeUnit()));
        }
        if (element.getChild("runLength") != null) {
            runControl.setRunLength(ExperimentParser.parsePeriod(element.getChild("runLength"), parent.getTimeUnit()));
        }
        List replicationElements = element.getChildren("replication");
        ArrayList<Replication> replicationArray = new ArrayList<Replication>();
        int number = 0;
        Iterator i = replicationElements.iterator();
        while (i.hasNext()) {
            replicationArray.add(ExperimentParser.parseReplication((Element)i.next(), runControl, number));
            ++number;
        }
        Replication[] replications = new Replication[replicationArray.size()];
        runControl.setReplications(replicationArray.toArray(replications));
        return runControl;
    }

    private static TimeUnitInterface parseTimeUnit(String name) throws Exception {
        if (name.equals("DAY")) {
            return TimeUnitInterface.DAY;
        }
        if (name.equals("HOUR")) {
            return TimeUnitInterface.HOUR;
        }
        if (name.equals("MILLISECOND")) {
            return TimeUnitInterface.MILLISECOND;
        }
        if (name.equals("MINUTE")) {
            return TimeUnitInterface.MINUTE;
        }
        if (name.equals("SECOND")) {
            return TimeUnitInterface.SECOND;
        }
        if (name.equals("WEEK")) {
            return TimeUnitInterface.WEEK;
        }
        if (name.equals("UNIT")) {
            return TimeUnitInterface.UNIT;
        }
        throw new Exception("parseTimeUnit.. unknown argument: " + name);
    }

    private static Treatment parseTreatment(Element element, Experiment parent, int number) throws Exception {
        Treatment treatment = new Treatment(parent, number);
        treatment.setTimeUnit(ExperimentParser.parseTimeUnit(element.getChildText("timeUnit")));
        if (element.getChild("startTime") != null) {
            treatment.setStartTime(ExperimentParser.parseDateTime(element.getChildText("startTime")));
        }
        treatment.setRunControl(ExperimentParser.parseRunControl(element.getChild("runControl"), treatment));
        if (element.getChild("properties") != null) {
            treatment.setProperties(ExperimentParser.parseProperties(element.getChild("properties")));
        }
        return treatment;
    }
}

