/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.logger;

import java.util.Collections;
import java.util.HashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import nl.tudelft.simulation.event.util.EventProducingMap;
import nl.tudelft.simulation.language.reflection.ClassUtil;

public final class Logger {
    public static final EventProducingMap LOGGERS = new EventProducingMap(Collections.synchronizedMap(new HashMap()));
    private static Class defaultHandler = class$java$util$logging$ConsoleHandler == null ? (class$java$util$logging$ConsoleHandler = Logger.class$("java.util.logging.ConsoleHandler")) : class$java$util$logging$ConsoleHandler;
    private static Level logLevel = Level.ALL;
    static /* synthetic */ Class class$java$util$logging$ConsoleHandler;
    static /* synthetic */ Class class$java$util$logging$Handler;

    private Logger() {
    }

    private static String resolveCaller(Object caller) {
        if (caller instanceof Class) {
            return ((Class)caller).getName();
        }
        return caller.getClass().getName();
    }

    public static synchronized java.util.logging.Logger resolveLogger(Object caller) {
        String loggerName;
        java.util.logging.Logger logger;
        if (caller == null) {
            return null;
        }
        Class callerClass = caller.getClass();
        if (caller instanceof Class) {
            callerClass = (Class)caller;
        }
        if ((logger = (java.util.logging.Logger)LOGGERS.get(loggerName = callerClass.getPackage().getName())) != null) {
            return logger;
        }
        return Logger.createLogger(loggerName);
    }

    private static synchronized java.util.logging.Logger createLogger(String loggerName) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(loggerName);
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            logger.removeHandler(handlers[i]);
        }
        Handler handler = null;
        try {
            handler = (Handler)ClassUtil.resolveConstructor(defaultHandler, null).newInstance(null);
        }
        catch (Exception exception) {
            handler = new ConsoleHandler();
        }
        handler.setLevel(logLevel);
        logger.addHandler(handler);
        logger.setLevel(logLevel);
        logger.setUseParentHandlers(false);
        LOGGERS.put(loggerName, logger);
        return logger;
    }

    public static void config(Object caller, String methodName, String msg) {
        Logger.resolveLogger(caller).logp(Level.CONFIG, Logger.resolveCaller(caller), methodName, msg);
    }

    public static void entering(Object caller, String arg0, String arg1, Object arg2) {
        Logger.resolveLogger(caller).entering(arg0, arg1, arg2);
    }

    public static void entering(Object caller, String arg0, String arg1, Object[] arg2) {
        Logger.resolveLogger(caller).entering(arg0, arg1, arg2);
    }

    public static void entering(Object caller, String arg0, String arg1) {
        Logger.resolveLogger(caller).entering(arg0, arg1);
    }

    public static void exiting(Object caller, String arg0, String arg1, Object arg2) {
        Logger.resolveLogger(caller).exiting(arg0, arg1, arg2);
    }

    public static void exiting(Object caller, String arg0, String arg1) {
        Logger.resolveLogger(caller).exiting(arg0, arg1);
    }

    public static void fine(Object caller, String methodName, String msg) {
        if (logLevel.equals(Level.FINE)) {
            Logger.resolveLogger(caller).logp(Level.FINE, Logger.resolveCaller(caller), methodName, msg);
        }
    }

    public static void finer(Object caller, String methodName, String msg) {
        Logger.resolveLogger(caller).logp(Level.FINER, Logger.resolveCaller(caller), methodName, msg);
    }

    public static void finest(Object caller, String methodName, String msg) {
        Logger.resolveLogger(caller).logp(Level.FINEST, Logger.resolveCaller(caller), methodName, msg);
    }

    public static synchronized String[] getLoggerNames() {
        return LOGGERS.keySet().toArray(new String[LOGGERS.keySet().size()]);
    }

    public static void info(Object caller, String methodName, String msg) {
        Logger.resolveLogger(caller).logp(Level.INFO, Logger.resolveCaller(caller), methodName, msg);
    }

    public static void log(Object caller, Level arg0, String arg1, Object arg2) {
        Logger.resolveLogger(caller).log(arg0, arg1, arg2);
    }

    public static void log(Object caller, Level arg0, String arg1, Object[] arg2) {
        Logger.resolveLogger(caller).log(arg0, arg1, arg2);
    }

    public static void log(Object caller, Level arg0, String arg1, Throwable arg2) {
        Logger.resolveLogger(caller).log(arg0, arg1, arg2);
    }

    public static void log(Object caller, Level arg0, String arg1) {
        Logger.resolveLogger(caller).log(arg0, arg1);
    }

    public static void log(Object caller, LogRecord arg0) {
        Logger.resolveLogger(caller).log(arg0);
    }

    public static void logp(Object caller, Level arg0, String arg1, String arg2, String arg3, Object arg4) {
        Logger.resolveLogger(caller).logp(arg0, arg1, arg2, arg3, arg4);
    }

    public static void logp(Object caller, Level arg0, String arg1, String arg2, String arg3, Object[] arg4) {
        Logger.resolveLogger(caller).logp(arg0, arg1, arg2, arg3, arg4);
    }

    public static void logp(Object caller, Level arg0, String arg1, String arg2, String arg3, Throwable arg4) {
        Logger.resolveLogger(caller).logp(arg0, arg1, arg2, arg3, arg4);
    }

    public static void logp(Object caller, Level arg0, String arg1, String arg2, String arg3) {
        Logger.resolveLogger(caller).logp(arg0, arg1, arg2, arg3);
    }

    public static void logrb(Object caller, Level arg0, String arg1, String arg2, String arg3, String arg4, Object arg5) {
        Logger.resolveLogger(caller).logrb(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public static void logrb(Object caller, Level arg0, String arg1, String arg2, String arg3, String arg4, Object[] arg5) {
        Logger.resolveLogger(caller).logrb(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public static void logrb(Object caller, Level arg0, String arg1, String arg2, String arg3, String arg4, Throwable arg5) {
        Logger.resolveLogger(caller).logrb(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public static void logrb(Object caller, Level arg0, String arg1, String arg2, String arg3, String arg4) {
        Logger.resolveLogger(caller).logrb(arg0, arg1, arg2, arg3, arg4);
    }

    public static void severe(Object caller, String methodName, String msg) {
        Logger.resolveLogger(caller).logp(Level.SEVERE, Logger.resolveCaller(caller), methodName, msg);
    }

    public static void severe(Object caller, String methodName, Throwable throwable) {
        Logger.resolveLogger(caller).logp(Level.SEVERE, Logger.resolveCaller(caller), methodName, throwable.getLocalizedMessage(), throwable);
    }

    public static void throwing(Object caller, String arg0, String arg1, Throwable arg2) {
        Logger.resolveLogger(caller).throwing(arg0, arg1, arg2);
    }

    public static void warning(Object caller, String methodName, String msg) {
        Logger.resolveLogger(caller).logp(Level.WARNING, Logger.resolveCaller(caller), methodName, msg);
    }

    public static void warning(Object caller, String methodName, Throwable thrown) {
        Logger.resolveLogger(caller).logp(Level.WARNING, Logger.resolveCaller(caller), methodName, thrown.getLocalizedMessage(), thrown);
    }

    public static Class getDefaultHandler() {
        return defaultHandler;
    }

    public static void setDefaultHandler(Class defaultHandler) {
        if (!(class$java$util$logging$Handler == null ? (class$java$util$logging$Handler = Logger.class$("java.util.logging.Handler")) : class$java$util$logging$Handler).isAssignableFrom(defaultHandler)) {
            throw new IllegalArgumentException("defaultHandler should extend Handler");
        }
        Logger.defaultHandler = defaultHandler;
    }

    public static Level getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(Level logLevel) {
        Logger.logLevel = logLevel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

