/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.animation.D3;

import java.awt.geom.Point2D;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Vector3d;
import nl.tudelft.simulation.dsol.animation.D3.Renderable3DInterface;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.animation.StaticLocation;
import nl.tudelft.simulation.dsol.context.ContextUtil;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;

public abstract class Renderable3D
extends BranchGroup
implements Renderable3DInterface {
    protected LocatableInterface source = null;
    protected SimulatorInterface simulator = null;
    protected TransformGroup locationGroup = null;
    protected int type = 1;
    protected double scale = 1.0;
    private Transform3D translate = new Transform3D();
    private Transform3D rotate = new Transform3D();
    private Transform3D yaw = new Transform3D();
    private Transform3D pitch = new Transform3D();
    private Transform3D roll = new Transform3D();
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$animation$LocatableInterface;

    public Renderable3D(SimulatorInterface simulator) {
        if (!(class$nl$tudelft$simulation$dsol$animation$LocatableInterface == null ? (class$nl$tudelft$simulation$dsol$animation$LocatableInterface = Renderable3D.class$("nl.tudelft.simulation.dsol.animation.LocatableInterface")) : class$nl$tudelft$simulation$dsol$animation$LocatableInterface).isAssignableFrom(this.getClass())) {
            throw new IllegalArgumentException("this class should implement Locatable interface");
        }
        this.source = (LocatableInterface)((Object)this);
        this.simulator = simulator;
        this.initialize();
    }

    public Renderable3D(DirectedPoint staticLocation, SimulatorInterface simulator) {
        this.source = new StaticLocation(staticLocation, null);
        this.simulator = simulator;
        this.type = 0;
        this.initialize();
    }

    public Renderable3D(DirectedPoint staticLocation, BranchGroup branchGroup, SimulatorInterface simulator) {
        this.source = new StaticLocation(staticLocation, null);
        this.simulator = simulator;
        this.type = 0;
        this.initializeTransformGroups();
        this.provideModel(this.locationGroup);
        this.addChild(this.locationGroup);
        this.addChild(branchGroup);
        this.update();
        ContextUtil.bindToContext(this.simulator, "/animation/3D", this);
    }

    public Renderable3D(Point2D staticLocation, SimulatorInterface simulator) {
        this(new DirectedPoint(staticLocation), simulator);
    }

    public Renderable3D(LocatableInterface source, SimulatorInterface simulator) {
        this.source = source;
        this.simulator = simulator;
        this.initialize();
    }

    private void initialize() {
        this.initializeTransformGroups();
        this.provideModel(this.locationGroup);
        this.addChild(this.locationGroup);
        this.update();
        ContextUtil.bindToContext(this.simulator, "/animation/3D", this);
    }

    private void initializeTransformGroups() {
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(17);
        this.setCapability(1);
        if (this.type == 1) {
            this.setPickable(true);
        } else {
            this.setPickable(false);
        }
        this.locationGroup = new TransformGroup();
        this.locationGroup.setCapability(17);
        this.locationGroup.setCapability(18);
        this.locationGroup.setCapability(12);
        this.locationGroup.setCapability(13);
        this.locationGroup.setCapability(14);
        if (this.type == 1) {
            this.locationGroup.setCapabilityIsFrequent(17);
            this.locationGroup.setCapabilityIsFrequent(17);
        }
    }

    protected abstract void provideModel(TransformGroup var1);

    public void update() {
        try {
            this.update(this.getAllChildren());
            DirectedPoint location = this.getSource().getLocation();
            this.translate.set(new Vector3d(location.x * this.scale, location.y * this.scale, location.z * this.scale));
            this.yaw.setRotation(new AxisAngle4d(0.0, 0.0, 1.0, location.getRotX()));
            this.pitch.setRotation(new AxisAngle4d(0.0, 1.0, 0.0, location.getRotZ()));
            this.roll.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, location.getRotY()));
            this.rotate.set(this.translate);
            this.rotate.mul(this.yaw);
            this.rotate.mul(this.pitch);
            this.rotate.mul(this.roll);
            this.locationGroup.setTransform(this.rotate);
        }
        catch (RemoteException exception) {
            this.rotate.set(new Vector3d(0.0, 0.0, 0.0));
            Logger.warning((Object)this, "update", exception);
        }
    }

    protected abstract void update(Enumeration var1);

    public LocatableInterface getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

