/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.animation.interpolation;

import nl.tudelft.simulation.dsol.animation.interpolation.InterpolationInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;

public class LinearInterpolation
implements InterpolationInterface {
    protected double startTime = Double.NaN;
    protected double endTime = Double.NaN;
    private DirectedPoint origin = null;
    private DirectedPoint destination = null;

    public LinearInterpolation(double startTime, double endTime, DirectedPoint origin, DirectedPoint destination) {
        if (endTime < startTime) {
            throw new IllegalArgumentException("endTime < startTime");
        }
        this.startTime = startTime;
        this.endTime = endTime;
        this.origin = (DirectedPoint)origin.clone();
        this.destination = (DirectedPoint)destination.clone();
    }

    public DirectedPoint getLocation(double time) {
        if (time <= this.startTime) {
            return this.origin;
        }
        if (time >= this.endTime) {
            return this.destination;
        }
        double fraction = (time - this.startTime) / (this.endTime - this.startTime);
        double x = this.origin.x + (this.destination.x - this.origin.x) * fraction;
        double y = this.origin.y + (this.destination.y - this.origin.y) * fraction;
        double z = this.origin.z + (this.destination.z - this.origin.z) * fraction;
        double rotY = this.origin.getRotY() + (this.destination.getRotY() - this.origin.getRotY()) * fraction;
        double rotZ = this.origin.getRotZ() + (this.destination.getRotZ() - this.origin.getRotZ()) * fraction;
        double rotX = this.origin.getRotX() + (this.destination.getRotX() - this.origin.getRotX()) * fraction;
        return new DirectedPoint(x, y, z, rotX, rotY, rotZ);
    }
}

