/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.eventlists;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nl.tudelft.simulation.dsol.eventlists.EventListInterface;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;

public class RedBlackTree
implements EventListInterface {
    private static long counter = 0L;
    protected static final boolean RED = false;
    protected static final boolean BLACK = true;
    protected Entry root = null;
    protected int size = 0;
    protected int modCount = 0;

    public synchronized boolean add(SimEventInterface event) {
        event.setID(counter++);
        Entry entry = this.root;
        if (entry == null) {
            this.incrementSize();
            this.root = new Entry(event, null);
            return true;
        }
        while (true) {
            int cmp;
            if ((cmp = event.compareTo(entry.simEvent)) == 0) {
                entry.simEvent = event;
                return false;
            }
            if (cmp < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize();
                entry.left = new Entry(event, entry);
                this.fixAfterInsertion(entry.left);
                return true;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        this.incrementSize();
        entry.right = new Entry(event, entry);
        this.fixAfterInsertion(entry.right);
        return true;
    }

    public synchronized boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.add((SimEventInterface)iterator.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    public synchronized boolean contains(SimEventInterface event) {
        if (this.root == null) {
            return false;
        }
        if (event == null) {
            return this.eventSearchNull(this.root);
        }
        return this.eventSearchNonNull(this.root, event);
    }

    public synchronized boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains((SimEventInterface)iterator.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized SimEventInterface first() {
        Entry first = this.firstEntry();
        if (first == null) {
            return null;
        }
        return first.simEvent;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized Iterator iterator() {
        return new EventListIterator();
    }

    public synchronized SimEventInterface last() {
        Entry last = this.lastEntry();
        if (last == null) {
            return null;
        }
        return last.simEvent;
    }

    public synchronized boolean remove(SimEventInterface event) {
        Entry entry = this.getEntry(event);
        if (entry == null) {
            return false;
        }
        this.deleteEntry(entry);
        return true;
    }

    public synchronized boolean removeAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.remove((SimEventInterface)iterator.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized SimEventInterface removeFirst() {
        Entry entry = this.firstEntry();
        this.deleteEntry(entry);
        return entry.simEvent;
    }

    public synchronized SimEventInterface removeLast() {
        Entry entry = this.lastEntry();
        this.deleteEntry(entry);
        return entry.simEvent;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized SimEventInterface[] toArray() {
        ArrayList result = new ArrayList();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result.toArray(new SimEventInterface[result.size()]);
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    protected Entry firstEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    private Entry lastEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    private boolean eventSearchNonNull(Entry entry, SimEventInterface event) {
        if (event.equals(entry.simEvent)) {
            return true;
        }
        return entry.left != null && this.eventSearchNonNull(entry.left, event) || entry.right != null && this.eventSearchNonNull(entry.right, event);
    }

    private boolean eventSearchNull(Entry entry) {
        if (entry.simEvent == null) {
            return true;
        }
        return entry.left != null && this.eventSearchNull(entry.left) || entry.right != null && this.eventSearchNull(entry.right);
    }

    private static boolean colorOf(Entry entry) {
        if (entry == null) {
            return true;
        }
        return entry.color;
    }

    private static Entry parentOf(Entry entry) {
        if (entry == null) {
            return null;
        }
        return entry.parent;
    }

    private static void setColor(Entry entry, boolean color) {
        if (entry != null) {
            entry.color = color;
        }
    }

    private static Entry leftOf(Entry entry) {
        if (entry == null) {
            return null;
        }
        return entry.left;
    }

    private static Entry rightOf(Entry entry) {
        if (entry == null) {
            return null;
        }
        return entry.right;
    }

    private void rotateLeft(Entry entry) {
        Entry right = entry.right;
        entry.right = right.left;
        if (right.left != null) {
            right.left.parent = entry;
        }
        right.parent = entry.parent;
        if (entry.parent == null) {
            this.root = right;
        } else if (entry.parent.left == entry) {
            entry.parent.left = right;
        } else {
            entry.parent.right = right;
        }
        right.left = entry;
        entry.parent = right;
    }

    private void rotateRight(Entry entry) {
        Entry left = entry.left;
        entry.left = left.right;
        if (left.right != null) {
            left.right.parent = entry;
        }
        left.parent = entry.parent;
        if (entry.parent == null) {
            this.root = left;
        } else if (entry.parent.right == entry) {
            entry.parent.right = left;
        } else {
            entry.parent.left = left;
        }
        left.right = entry;
        entry.parent = left;
    }

    private void fixAfterInsertion(Entry entry) {
        entry.color = false;
        while (entry != null && entry != this.root && !entry.parent.color) {
            Entry y;
            if (RedBlackTree.parentOf(entry) == RedBlackTree.leftOf(RedBlackTree.parentOf(RedBlackTree.parentOf(entry)))) {
                y = RedBlackTree.rightOf(RedBlackTree.parentOf(RedBlackTree.parentOf(entry)));
                if (!RedBlackTree.colorOf(y)) {
                    RedBlackTree.setColor(RedBlackTree.parentOf(entry), true);
                    RedBlackTree.setColor(y, true);
                    RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(entry)), false);
                    entry = RedBlackTree.parentOf(RedBlackTree.parentOf(entry));
                    continue;
                }
                if (entry == RedBlackTree.rightOf(RedBlackTree.parentOf(entry))) {
                    entry = RedBlackTree.parentOf(entry);
                    this.rotateLeft(entry);
                }
                RedBlackTree.setColor(RedBlackTree.parentOf(entry), true);
                RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(entry)), false);
                if (RedBlackTree.parentOf(RedBlackTree.parentOf(entry)) == null) continue;
                this.rotateRight(RedBlackTree.parentOf(RedBlackTree.parentOf(entry)));
                continue;
            }
            y = RedBlackTree.leftOf(RedBlackTree.parentOf(RedBlackTree.parentOf(entry)));
            if (!RedBlackTree.colorOf(y)) {
                RedBlackTree.setColor(RedBlackTree.parentOf(entry), true);
                RedBlackTree.setColor(y, true);
                RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(entry)), false);
                entry = RedBlackTree.parentOf(RedBlackTree.parentOf(entry));
                continue;
            }
            if (entry == RedBlackTree.leftOf(RedBlackTree.parentOf(entry))) {
                entry = RedBlackTree.parentOf(entry);
                this.rotateRight(entry);
            }
            RedBlackTree.setColor(RedBlackTree.parentOf(entry), true);
            RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(entry)), false);
            if (RedBlackTree.parentOf(RedBlackTree.parentOf(entry)) == null) continue;
            this.rotateLeft(RedBlackTree.parentOf(RedBlackTree.parentOf(entry)));
        }
        this.root.color = true;
    }

    protected void deleteEntry(Entry entry) {
        Entry replacement;
        this.decrementSize();
        if (entry.left != null && entry.right != null) {
            Entry s = this.successor(entry);
            entry.simEvent = s.simEvent;
            entry = s;
        }
        if ((replacement = entry.left) == null) {
            replacement = entry.right;
        }
        if (replacement != null) {
            replacement.parent = entry.parent;
            if (entry.parent == null) {
                this.root = replacement;
            } else if (entry == entry.parent.left) {
                entry.parent.left = replacement;
            } else {
                entry.parent.right = replacement;
            }
            entry.left = null;
            entry.right = null;
            entry.parent = null;
            if (entry.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (entry.parent == null) {
            this.root = null;
        } else {
            if (entry.color) {
                this.fixAfterDeletion(entry);
            }
            if (entry.parent != null) {
                if (entry == entry.parent.left) {
                    entry.parent.left = null;
                } else if (entry == entry.parent.right) {
                    entry.parent.right = null;
                }
                entry.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry entry) {
        while (entry != this.root && RedBlackTree.colorOf(entry)) {
            Entry sib;
            if (entry == RedBlackTree.leftOf(RedBlackTree.parentOf(entry))) {
                sib = RedBlackTree.rightOf(RedBlackTree.parentOf(entry));
                if (!RedBlackTree.colorOf(sib)) {
                    RedBlackTree.setColor(sib, true);
                    RedBlackTree.setColor(RedBlackTree.parentOf(entry), false);
                    this.rotateLeft(RedBlackTree.parentOf(entry));
                    sib = RedBlackTree.rightOf(RedBlackTree.parentOf(entry));
                }
                if (RedBlackTree.colorOf(RedBlackTree.leftOf(sib)) && RedBlackTree.colorOf(RedBlackTree.rightOf(sib))) {
                    RedBlackTree.setColor(sib, false);
                    entry = RedBlackTree.parentOf(entry);
                    continue;
                }
                if (RedBlackTree.colorOf(RedBlackTree.rightOf(sib))) {
                    RedBlackTree.setColor(RedBlackTree.leftOf(sib), true);
                    RedBlackTree.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = RedBlackTree.rightOf(RedBlackTree.parentOf(entry));
                }
                RedBlackTree.setColor(sib, RedBlackTree.colorOf(RedBlackTree.parentOf(entry)));
                RedBlackTree.setColor(RedBlackTree.parentOf(entry), true);
                RedBlackTree.setColor(RedBlackTree.rightOf(sib), true);
                this.rotateLeft(RedBlackTree.parentOf(entry));
                entry = this.root;
                continue;
            }
            sib = RedBlackTree.leftOf(RedBlackTree.parentOf(entry));
            if (!RedBlackTree.colorOf(sib)) {
                RedBlackTree.setColor(sib, true);
                RedBlackTree.setColor(RedBlackTree.parentOf(entry), false);
                this.rotateRight(RedBlackTree.parentOf(entry));
                sib = RedBlackTree.leftOf(RedBlackTree.parentOf(entry));
            }
            if (RedBlackTree.colorOf(RedBlackTree.rightOf(sib)) && RedBlackTree.colorOf(RedBlackTree.leftOf(sib))) {
                RedBlackTree.setColor(sib, false);
                entry = RedBlackTree.parentOf(entry);
                continue;
            }
            if (RedBlackTree.colorOf(RedBlackTree.leftOf(sib))) {
                RedBlackTree.setColor(RedBlackTree.rightOf(sib), true);
                RedBlackTree.setColor(sib, false);
                this.rotateLeft(sib);
                sib = RedBlackTree.leftOf(RedBlackTree.parentOf(entry));
            }
            RedBlackTree.setColor(sib, RedBlackTree.colorOf(RedBlackTree.parentOf(entry)));
            RedBlackTree.setColor(RedBlackTree.parentOf(entry), true);
            RedBlackTree.setColor(RedBlackTree.leftOf(sib), true);
            this.rotateRight(RedBlackTree.parentOf(entry));
            entry = this.root;
        }
        RedBlackTree.setColor(entry, true);
    }

    private Entry getEntry(SimEventInterface event) {
        Entry entry = this.root;
        while (entry != null) {
            int cmp = event.compareTo(entry.simEvent);
            if (cmp < 0) {
                entry = entry.left;
                continue;
            }
            if (cmp > 0) {
                entry = entry.right;
                continue;
            }
            if (cmp != 0) continue;
            return entry;
        }
        return null;
    }

    protected Entry successor(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry right = entry.right;
            while (right.left != null) {
                right = right.left;
            }
            return right;
        }
        Entry right = entry.parent;
        Entry ch = entry;
        while (right != null && ch == right.right) {
            ch = right;
            right = right.parent;
        }
        return right;
    }

    private class EventListIterator
    extends EntryIterator {
        public Object next() {
            return ((Entry)super.next()).simEvent;
        }
    }

    private class EntryIterator
    implements Iterator {
        protected int expectedModCount;
        protected Entry lastReturned;
        protected Entry next;

        public EntryIterator() {
            this.expectedModCount = RedBlackTree.this.modCount;
            this.lastReturned = null;
            this.next = null;
            this.next = RedBlackTree.this.firstEntry();
        }

        public EntryIterator(Entry first) {
            this.expectedModCount = RedBlackTree.this.modCount;
            this.lastReturned = null;
            this.next = null;
            this.next = first;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public final Entry nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (RedBlackTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = RedBlackTree.this.successor(this.next);
            return this.lastReturned;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (RedBlackTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            RedBlackTree.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    private static class Entry
    implements Serializable {
        protected SimEventInterface simEvent = null;
        protected Entry left = null;
        protected Entry right = null;
        protected Entry parent = null;
        protected boolean color = true;

        public Entry() {
        }

        public Entry(SimEventInterface simEvent) {
            this();
            this.simEvent = simEvent;
        }

        public Entry(SimEventInterface simEvent, Entry parent) {
            this(simEvent);
            this.parent = parent;
        }

        public Entry(SimEventInterface simEvent, Entry parent, Entry left, Entry right) {
            this(simEvent, parent);
            this.left = left;
            this.right = right;
        }
    }
}

