/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.eventlists;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import nl.tudelft.simulation.dsol.eventlists.EventListInterface;
import nl.tudelft.simulation.dsol.eventlists.RedBlackTree;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.logger.Logger;

public class TableModelEventList
extends RedBlackTree {
    public static final EventType EVENTLIST_CHANCED_EVENT = null;
    public static final String[] HEADER = new String[]{"Time", "Source", "Target", "Method"};
    private DefaultTableModel tableModel = new DefaultTableModel(HEADER, 0);
    private boolean showPackage = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableModelEventList(EventListInterface origin) {
        EventListInterface eventListInterface = origin;
        synchronized (eventListInterface) {
            List<SimEventInterface> collection = Arrays.asList(origin.toArray());
            this.addAll(collection);
        }
    }

    public synchronized EventListInterface getOrigin() {
        RedBlackTree result = new RedBlackTree();
        result.addAll(Arrays.asList(this.toArray()));
        return result;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    private void updateTableModel() {
        try {
            this.tableModel.setRowCount(0);
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Object[] row = new Object[4];
                SimEvent event = (SimEvent)i.next();
                row[0] = new Double(event.getAbsoluteExecutionTime());
                row[1] = this.formatObject(event.getSource().toString());
                row[2] = this.formatObject(event.getTarget().toString());
                row[3] = this.formatObject(event.getMethod().toString());
                this.tableModel.addRow(row);
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, "updateTableModel", exception);
        }
    }

    private String formatObject(String label) {
        if (label == null) {
            return "null";
        }
        if (this.showPackage) {
            return label;
        }
        return label.substring(label.lastIndexOf(".") + 1);
    }

    public void setShowPackage(boolean showPackage) {
        this.showPackage = showPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean add(SimEventInterface value) {
        DefaultTableModel defaultTableModel = this.tableModel;
        synchronized (defaultTableModel) {
            boolean result = super.add(value);
            this.updateTableModel();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addAll(Collection collection) {
        DefaultTableModel defaultTableModel = this.tableModel;
        synchronized (defaultTableModel) {
            boolean result = super.addAll(collection);
            this.updateTableModel();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        DefaultTableModel defaultTableModel = this.tableModel;
        synchronized (defaultTableModel) {
            super.clear();
            this.updateTableModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(SimEventInterface value) {
        DefaultTableModel defaultTableModel = this.tableModel;
        synchronized (defaultTableModel) {
            boolean result = super.remove(value);
            this.updateTableModel();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeAll(Collection collection) {
        DefaultTableModel defaultTableModel = this.tableModel;
        synchronized (defaultTableModel) {
            boolean result = super.removeAll(collection);
            this.updateTableModel();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SimEventInterface removeFirst() {
        DefaultTableModel defaultTableModel = this.tableModel;
        synchronized (defaultTableModel) {
            SimEventInterface result = super.removeFirst();
            this.updateTableModel();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SimEventInterface removeLast() {
        DefaultTableModel defaultTableModel = this.tableModel;
        synchronized (defaultTableModel) {
            SimEventInterface result = super.removeLast();
            this.updateTableModel();
            return result;
        }
    }
}

