/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.experiment;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.Context;
import javax.naming.InitialContext;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.experiment.Treatment;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.logger.Logger;

public class RunControl
extends EventProducer
implements Serializable,
EventListenerInterface {
    public static final EventType END_OF_RUN_EVENT = new EventType("END_OF_RUN_EVENT");
    protected Treatment treatment = null;
    private Replication[] replications;
    private double warmupPeriod = 0.0;
    private double runLength = Double.NaN;
    private int replication = 0;

    public RunControl(Treatment treatment) {
        this.treatment = treatment;
        this.addListener(treatment.getRunControl(), END_OF_RUN_EVENT, false);
    }

    public void start(SimulatorInterface simulator) throws RemoteException {
        simulator.addListener(this, SimulatorInterface.END_OF_REPLICATION_EVENT, (short)-1, false);
        this.replication = 0;
        this.notify((EventInterface)new Event(SimulatorInterface.END_OF_REPLICATION_EVENT, (Object)simulator, null));
    }

    public Treatment getTreatment() {
        return this.treatment;
    }

    public Replication[] getReplications() {
        return this.replications;
    }

    public double getRunLength() {
        return this.runLength;
    }

    public double getWarmupPeriod() {
        return this.warmupPeriod;
    }

    public void notify(EventInterface event) {
        try {
            if (event.getType().equals((Object)SimulatorInterface.END_OF_REPLICATION_EVENT)) {
                SimulatorInterface simulator = (SimulatorInterface)event.getSource();
                if (this.replication < this.replications.length) {
                    Context context = (Context)new InitialContext().lookup(this.treatment.getExperiment().getRun() + "/treatment(" + this.treatment.getNumber() + ")");
                    context.createSubcontext("replication(" + this.replication + ")");
                    context.createSubcontext("replication(" + this.replication + ")/animation");
                    context.createSubcontext("replication(" + this.replication + ")/animation/2D");
                    context.createSubcontext("replication(" + this.replication + ")/animation/3D");
                    simulator.initialize(this.replications[this.replication]);
                    ++this.replication;
                    simulator.start();
                } else {
                    this.fireEvent((EventInterface)new Event(END_OF_RUN_EVENT, (Object)this, null));
                }
            }
        }
        catch (Exception exception) {
            Logger.warning((Object)this, "notify", exception);
        }
    }

    public synchronized void reset() {
        this.replication = 0;
        for (int i = 0; i < this.replications.length; ++i) {
            this.replications[i].reset();
        }
    }

    public void setReplications(Replication[] replications) {
        this.replications = replications;
    }

    public void setRunLength(double runLength) {
        this.runLength = runLength;
    }

    public void setWarmupPeriod(double warmupPeriod) {
        this.warmupPeriod = warmupPeriod;
    }

    public String toString() {
        String result = super.toString() + " ; RL=" + this.getRunLength() + " ; WP=" + this.getWarmupPeriod() + " ; replications=[";
        for (int i = 0; i < this.replications.length; ++i) {
            result = result + this.replications[i].toString() + " ; ";
        }
        result = result.substring(0, result.length() - 2) + "]";
        return "[" + result;
    }
}

