/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.formalisms;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.formalisms.ResourceRequestorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;

public class Resource
extends EventProducer {
    protected static long counter = 0L;
    public static final EventType UTILIZATION_EVENT = new EventType("UTILIZATION_EVENT");
    public static final EventType RESOURCE_REQUESTED_QUEUE_LENGTH = new EventType("RESOURCE_REQUESTED_QUEUE_LENGTH");
    public static final int MIN_REQUEST_PRIORITY = 0;
    public static final int MAX_REQUEST_PRIORITY = 10;
    public static final int DEFAULT_REQUEST_PRIORITY = 5;
    protected double capacity;
    protected double claimedCapacity = 0.0;
    protected SortedSet requests = Collections.synchronizedSortedSet(new TreeSet(new RequestComparator()));
    protected DEVSSimulatorInterface simulator;
    protected String description = "resource";

    public Resource(DEVSSimulatorInterface simulator, String description, double capacity) {
        this.description = description;
        this.simulator = simulator;
        this.capacity = capacity;
    }

    public Resource(DEVSSimulatorInterface simulator, double capacity) {
        this(simulator, "resource", capacity);
    }

    public double getCapacity() {
        return this.capacity;
    }

    public double getClaimedCapacity() {
        return this.claimedCapacity;
    }

    public double getAvailableCapacity() {
        return this.capacity - this.claimedCapacity;
    }

    public int getQueueLength() {
        return this.requests.size();
    }

    private synchronized void alterClaimedCapacity(double amount) throws RemoteException {
        this.claimedCapacity += amount;
        this.fireEvent(UTILIZATION_EVENT, this.claimedCapacity, this.simulator.getSimulatorTime());
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
    }

    public synchronized void requestCapacity(double amount, ResourceRequestorInterface requestor) throws RemoteException, SimRuntimeException {
        this.requestCapacity(amount, requestor, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestCapacity(double amount, ResourceRequestorInterface requestor, int priority) throws RemoteException, SimRuntimeException {
        if (amount < 0.0) {
            throw new SimRuntimeException("requested capacity on resource cannot <0.0");
        }
        if (this.claimedCapacity + amount <= this.capacity) {
            this.alterClaimedCapacity(amount);
            this.simulator.scheduleEvent(0.0, (Object)this, requestor, "receiveRequestedResource", new Object[]{new Double(amount), this});
        } else {
            SortedSet sortedSet = this.requests;
            synchronized (sortedSet) {
                this.requests.add(new Request(requestor, amount, priority));
            }
            this.fireEvent(RESOURCE_REQUESTED_QUEUE_LENGTH, this.requests.size(), this.simulator.getSimulatorTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCapacity(double amount) throws RemoteException {
        if (amount < 0.0) {
            throw new IllegalArgumentException("released capacity on resource cannot <0.0");
        }
        if (amount > 0.0) {
            this.alterClaimedCapacity(-amount);
        }
        SortedSet sortedSet = this.requests;
        synchronized (sortedSet) {
            Iterator i = this.requests.iterator();
            while (i.hasNext()) {
                Request request = (Request)i.next();
                if (this.capacity - this.claimedCapacity >= request.getAmount()) {
                    this.alterClaimedCapacity(request.getAmount());
                    request.getRequestor().receiveRequestedResource(request.getAmount(), this);
                    SortedSet sortedSet2 = this.requests;
                    synchronized (sortedSet2) {
                        i.remove();
                    }
                    this.fireEvent(RESOURCE_REQUESTED_QUEUE_LENGTH, this.requests.size(), this.simulator.getSimulatorTime());
                    continue;
                }
                return;
            }
        }
    }

    public String toString() {
        return this.description;
    }

    public static class Request {
        private int priority = 5;
        private long id = -1L;
        private ResourceRequestorInterface requestor;
        private double amount;

        public Request(ResourceRequestorInterface requestor, double amount, int priority) {
            this.requestor = requestor;
            this.amount = amount;
            this.priority = priority;
            this.id = ++counter;
        }

        public double getAmount() {
            return this.amount;
        }

        public ResourceRequestorInterface getRequestor() {
            return this.requestor;
        }

        public int getPriority() {
            return this.priority;
        }

        public long getId() {
            return this.id;
        }

        public String toString() {
            return "RequestForResource[requestor=" + this.requestor + ";amount=" + this.amount + ";priority=" + this.priority + "]";
        }
    }

    private class RequestComparator
    implements Comparator {
        private RequestComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Request r0 = (Request)arg0;
            Request r1 = (Request)arg1;
            if (r0.getPriority() > r1.getPriority()) {
                return -1;
            }
            if (r0.getPriority() < r1.getPriority()) {
                return 1;
            }
            if (r0.getId() < r1.getId()) {
                return -1;
            }
            if (r0.getId() > r1.getId()) {
                return 1;
            }
            return 0;
        }
    }
}

