/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.formalisms.dess;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquationInterface;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;
import nl.tudelft.simulation.logger.Logger;

public abstract class DifferentialEquation
extends nl.tudelft.simulation.jstats.ode.DifferentialEquation
implements DifferentialEquationInterface,
EventListenerInterface {
    protected DESSSimulatorInterface simulator = null;
    protected double previousX = 0.0;
    protected double[] previousY = null;

    public DifferentialEquation(DESSSimulatorInterface simulator) throws RemoteException {
        this(simulator, simulator.getTimeStep(), 3);
    }

    public DifferentialEquation(DESSSimulatorInterface simulator, double timeStep) {
        this(simulator, timeStep, 3);
    }

    public DifferentialEquation(DESSSimulatorInterface simulator, double timeStep, short numericalMethod) {
        super(timeStep, numericalMethod);
        this.simulator = simulator;
        try {
            simulator.addListener(this, SimulatorInterface.TIME_CHANGED_EVENT, false);
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, "DifferentialEquation", exception);
        }
    }

    public DifferentialEquation(DESSSimulatorInterface simulator, double timeStep, NumericalIntegrator numericalIntegrator) {
        super(timeStep, numericalIntegrator);
        this.simulator = simulator;
        try {
            simulator.addListener(this, SimulatorInterface.TIME_CHANGED_EVENT, false);
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, "DifferentialEquation", exception);
        }
    }

    public synchronized void notify(EventInterface event) throws RemoteException {
        if (event.getSource() instanceof DESSSimulatorInterface && event.getType().equals((Object)SimulatorInterface.TIME_CHANGED_EVENT)) {
            if (this.simulator.getSimulatorTime() < this.x0 || Double.isNaN(this.x0)) {
                return;
            }
            this.previousY = this.integrateY(this.simulator.getSimulatorTime(), this.previousX, this.previousY);
            for (int i = 0; i < this.y0.length; ++i) {
                this.fireEvent(DifferentialEquationInterface.VALUE_CHANGED_EVENT[i], this.previousY[i], this.simulator.getSimulatorTime());
            }
            this.previousX = this.simulator.getSimulatorTime();
        }
    }

    public void initialize(double x, double[] y) {
        super.initialize(x, y);
        this.previousX = x;
        this.previousY = y;
    }

    public abstract /* synthetic */ double[] dy(double var1, double[] var3);

    static {
        for (int i = 0; i < DifferentialEquationInterface.VALUE_CHANGED_EVENT.length; ++i) {
            DifferentialEquationInterface.VALUE_CHANGED_EVENT[i] = new EventType("VALUE_CHANGED_EVENT[" + i + "]");
        }
    }
}

