/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.formalisms.flow;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.simulation.dsol.formalisms.Resource;
import nl.tudelft.simulation.dsol.formalisms.ResourceRequestorInterface;
import nl.tudelft.simulation.dsol.formalisms.flow.Station;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.logger.Logger;

public class Seize
extends Station
implements ResourceRequestorInterface {
    public static final EventType QUEUE_LENGTH_EVENT = new EventType("QUEUE_QUEUE_LENGTH_EVENTLENGTH_EVENT");
    public static final EventType DELAY_TIME = new EventType("DELAY_TIME");
    private List queue = Collections.synchronizedList(new ArrayList());
    private double requestedCapacity = Double.NaN;
    private Resource resource;

    public Seize(DEVSSimulatorInterface simulator, Resource resource) {
        this(simulator, resource, 1.0);
    }

    public Seize(DEVSSimulatorInterface simulator, Resource resource, double requestedCapacity) {
        super(simulator);
        if (requestedCapacity < 0.0) {
            throw new IllegalArgumentException("requestedCapacity cannot < 0.0");
        }
        this.requestedCapacity = requestedCapacity;
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receiveObject(Object object, double requestedCapacity) throws RemoteException {
        super.receiveObject(object);
        Request request = new Request(object, requestedCapacity, this.simulator.getSimulatorTime());
        List list = this.queue;
        synchronized (list) {
            this.queue.add(request);
        }
        try {
            this.fireEvent(QUEUE_LENGTH_EVENT, this.queue.size(), this.simulator.getSimulatorTime());
            this.resource.requestCapacity(requestedCapacity, this);
        }
        catch (Exception exception) {
            Logger.warning((Object)this, "receiveObject", exception);
        }
    }

    public void receiveObject(Object object) throws RemoteException {
        this.receiveObject(object, this.requestedCapacity);
    }

    public void setQueue(List queue) {
        this.queue = queue;
    }

    public List getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveRequestedResource(double requestedCapacity, Resource resource) throws RemoteException {
        Iterator i = this.queue.iterator();
        while (i.hasNext()) {
            Request request = (Request)i.next();
            if (request.getAmount() != requestedCapacity) continue;
            List list = this.queue;
            synchronized (list) {
                this.queue.remove(request);
            }
            this.fireEvent(QUEUE_LENGTH_EVENT, this.queue.size(), this.simulator.getSimulatorTime());
            double delay = this.simulator.getSimulatorTime() - request.getCreationTime();
            this.fireEvent(DELAY_TIME, delay, this.simulator.getSimulatorTime());
            this.releaseObject(request.getEntity());
            return;
        }
    }

    private class Request {
        private double amount;
        private Object entity;
        private double creationTime = Double.NaN;

        public Request(Object entity, double amount, double creationTime) {
            this.entity = entity;
            this.amount = amount;
            this.creationTime = creationTime;
        }

        public double getAmount() {
            return this.amount;
        }

        public Object getEntity() {
            return this.entity;
        }

        public double getCreationTime() {
            return this.creationTime;
        }
    }
}

