/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.simulators;

import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVDESSSimulator;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

public class Animator
extends DEVDESSSimulator
implements AnimatorInterface {
    protected long animationDelay = 100L;

    public long getAnimationDelay() {
        return this.animationDelay;
    }

    public void setAnimationDelay(long animationDelay) {
        this.animationDelay = animationDelay;
        Logger.finer(this, "setAnimationDelay", "set the animationDelay to " + animationDelay);
        this.fireEvent(AnimatorInterface.ANIMATION_DELAY_CHANGED_EVENT, animationDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning() && !this.eventList.isEmpty() && this.simulatorTime <= this.replication.getRunControl().getRunLength()) {
            try {
                if (this.animationDelay > 0L) {
                    Thread.sleep(this.animationDelay);
                }
            }
            catch (Exception exception2) {
                Object exception2 = null;
            }
            double runUntil = this.simulatorTime + this.timeStep;
            while (!this.eventList.isEmpty() && this.running && runUntil >= this.eventList.first().getAbsoluteExecutionTime()) {
                Object object = this.semaphore;
                synchronized (object) {
                    SimEventInterface event = this.eventList.removeFirst();
                    this.simulatorTime = event.getAbsoluteExecutionTime();
                    this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
                    try {
                        event.execute();
                    }
                    catch (Exception exception) {
                        Logger.severe((Object)this, "run", exception);
                    }
                }
            }
            if (this.running) {
                this.simulatorTime = runUntil;
            }
            this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
            this.fireEvent(AnimatorInterface.UPDATE_ANIMATION_EVENT, this.simulatorTime);
        }
    }
}

