/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.simulators;

import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.Animator;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVDESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.logger.Logger;

public class RealTimeClock
extends Animator
implements DEVDESSSimulatorInterface {
    public static final EventType BACKLOG_EVENT = new EventType("BACKLOG_EVENT");
    private long backlog = 0L;
    private long startTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.worker.setPriority(10);
        this.startTime = System.currentTimeMillis();
        int count = 0;
        long animationFactor = Math.round((double)this.animationDelay / this.timeStep);
        while (this.isRunning() && !this.eventList.isEmpty() && this.simulatorTime <= this.replication.getRunControl().getRunLength()) {
            long now = System.currentTimeMillis();
            double runUntil = (double)(now - this.startTime) + this.timeStep;
            while (!this.eventList.isEmpty() && this.running && runUntil >= this.eventList.first().getAbsoluteExecutionTime()) {
                Object object = this.semaphore;
                synchronized (object) {
                    SimEventInterface event = this.eventList.removeFirst();
                    this.simulatorTime = event.getAbsoluteExecutionTime();
                    try {
                        event.execute();
                    }
                    catch (Exception exception) {
                        Logger.severe((Object)this, "run", exception);
                    }
                }
            }
            if (this.running) {
                this.simulatorTime = runUntil;
            }
            this.fireEvent(SimulatorInterface.TIME_CHANGED_EVENT, this.simulatorTime, this.simulatorTime);
            if ((long)count % animationFactor == 0L) {
                this.fireEvent(AnimatorInterface.UPDATE_ANIMATION_EVENT, this.simulatorTime, this.simulatorTime);
            }
            ++count;
            try {
                long used = System.currentTimeMillis() - now;
                long delay = Math.round(this.timeStep - (double)used);
                if (delay >= 0L) {
                    long catchUp = Math.min(this.backlog, delay);
                    this.backlog -= catchUp;
                    super.fireEvent(BACKLOG_EVENT, -delay + catchUp);
                    Thread.sleep(delay - catchUp);
                    continue;
                }
                this.backlog += -1L * delay;
                super.fireEvent(BACKLOG_EVENT, -1L * delay);
            }
            catch (InterruptedException interruptedException2) {
                Object interruptedException2 = null;
            }
        }
    }

    public long getAnimationDelay() {
        return this.animationDelay;
    }

    public void setAnimationDelay(long animationDelay) {
        if ((double)animationDelay < this.timeStep) {
            Logger.warning((Object)this, "setAnimationDelay", "Be careful: it does not seem wise to have an animationdelay<timeStep");
        }
        this.animationDelay = animationDelay;
    }
}

