@REM ----------------------------------------------------------------------------
@REM Copyright 2001-2004 Delft University of Technology, the Netherlands
@REM 
@REM Licensed under the GPL licence Version 2.0 (the "License");
@REM you may not use this file except in compliance with the License.
@REM You may obtain a copy of the License at
@REM 
@REM      http://www.gnu.org/copyleft/gpl.html
@REM 
@REM Unless required by applicable law or agreed to in writing, software
@REM distributed under the License is distributed on an "AS IS" BASIS,
@REM WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM See the License for the specific language governing permissions and
@REM limitations under the License.
@REM ----------------------------------------------------------------------------
@REM 

@REM ----------------------------------------------------------------------------
@REM DSOL Start Up Batch script
@REM
@REM Required ENV vars:
@REM JAVA_HOME - location of a JDK home dir
@REM
@REM Optional ENV vars
@REM ----------------------------------------------------------------------------

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM ==== START VALIDATION ====
if not "%JAVA_HOME%" == "" goto OkJHome

echo.
echo ERROR: JAVA_HOME not found in your environment.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation
echo.
goto end

:OkJHome
if exist "%JAVA_HOME%\bin\java.exe" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory.
echo JAVA_HOME = %JAVA_HOME%
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation
echo.
goto end

@REM ==== END VALIDATION ====

:init
@REM Decide how to startup depending on the version of windows

SET DSOL_JAVA_EXE="%JAVA_HOME%\bin\java.exe"

SET DSOL_CLASSPATH=".\dsol-gui-1.6.6.jar;.\lib\j3d-core-utils-1.3.1.jar;.\lib\vecmath-1.3.1.jar;.\lib\j3d-core-1.3.1.jar;.\lib\language-1.6.6.jar;.\lib\logger-1.6.4.jar;.\lib\event-1.6.5.jar;.\lib\interpreter-1.6.7.jar;.\lib\jstats-1.6.6.jar;.\lib\naming-1.6.3.jar;.\lib\introspection-1.6.4.jar;.\lib\dsol-1.6.6.jar;.\lib\dsol-xml-1.6.4.jar;.\lib\looks-1.2.2.jar;.\lib\TableLayout-20020517.jar;.\lib\jdom-1.0.jar;.\lib\jlfgr-1.0.jar;.\lib\sax-2.0.1.jar;.\lib\xercesImpl-2.6.1.jar;.\lib\dom4j-1.5.jar;.\lib\xml-apis-2.0.2.jar;.\lib\colt-1.0.3.jar;.\lib\jcommon-0.9.5.jar;.\lib\jfreechart-0.9.20.jar;.\lib\math-1.0.0.jar;.\lib\gisbeans-1.0.0-beta5.jar;"
SET DSOL_MAIN_CLASS="nl.tudelft.simulation.dsol.gui.DSOLApplication"

echo Starting DSOL...
%DSOL_JAVA_EXE% -classpath %DSOL_CLASSPATH% %DSOL_MAIN_CLASS%
