/*
 * @(#) ConsoleRunner.java Dec 1, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section25;

import java.net.URL;

import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulator;
import nl.tudelft.simulation.xml.dsol.ExperimentParser;

/**
 * A ConsoleRunner <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Dec 1, 2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public final class ConsoleRunner
{

	/**
	 * constructs a new ConsoleRunner
	 */
	private ConsoleRunner()
	{
		//unreachable code
	}

	/**
	 * executes our model
	 * 
	 * @param args the experiment xml-file url
	 */
	public static void main(final String[] args)
	{
		if (args.length != 1)
		{
			System.out.println("Usage : java nl.tudelft.simulation.dsol."
					+ "tutorial.section24.ConsoleRunner [experiment-url]");
			System.exit(0);
		}
		try
		{
			//First we resolve the experiment and parse it
			URL experimentURL = new URL(args[0].toString());
			Experiment experiment = ExperimentParser
					.parseExperiment(experimentURL);

			//Now we set the simulator
			experiment.setSimulator(new DEVSSimulator());

			//Finally we set the model
			experiment.setModel(new Model());

			//We are ready to start
			experiment.start();
		} catch (Exception exception)
		{
			exception.printStackTrace();
		}
	}
}