/*
 * @(#) Model.java Dec 1, 2003
 * 
 * Copyright (c) 2003-2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section25;

import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;

/**
 * The Model class as presented in section 2.5 in the DSOL tutorial.
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl"> Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.1 Sep 6, 2004 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public class Model implements ModelInterface
{
	/**
	 * constructs a new Model
	 */
	public Model()
	{
		super();
	}

	/**
	 * @see nl.tudelft.simulation.dsol.ModelInterface
	 *      #constructModel(nl.tudelft.simulation.dsol.simulators.SimulatorInterface)
	 */
	public void constructModel(final SimulatorInterface simulator)
	{
		DEVSSimulatorInterface devsSimulator = (DEVSSimulatorInterface) simulator;
		new Customer(devsSimulator);
	}
}