/*
 * @(#) Order.java Dec 4, 2003
 * 
 * Copyright (c) 2003-2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section25;

/**
 * The Order class as presented in section 2.5 in the DSOL tutorial.
 * <p>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl"> Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.1 Sep 6, 2004 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja">Peter Jacobs </a>
 */
public class Order
{
	/** the product of an order */
	private String product = null;

	/** the amount of product to order */
	private double amount = Double.NaN;

	/**
	 * constructs a new Order
	 * 
	 * @param product the product
	 * @param amount the amount to buy
	 */
	public Order(final String product, final double amount)
	{
		super();
		this.product = product;
		this.amount = amount;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return "Order[" + this.product + ";" + this.amount + "]";
	}
}