/*
 * @(#) Customer.java Dec 8, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section42;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistCustom;
import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.distributions.DistExponential;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * A Customer <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Dec 8, 2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class Customer implements BuyerInterface
{
	/** the simulator to schedule on */
	private DEVSSimulatorInterface simulator = null;

	/** the retailer by whom we order our product */
	private SellerInterface retailer = null;

	/** the intervalTime between consequtive orders */
	private DistContinuous intervalTime = null;

	/** the orderBatchSize of an order */
	private DistDiscrete orderBatchSize = null;

	/**
	 * constructs a new Customer
	 * 
	 * @param simulator the simulator to schedule on
	 * @param retailer the retailer to buy at. In more advanced examples, we
	 *        would look up this retailer at a yellow page.
	 * @throws RemoteException on network failure
	 *  
	 */
	public Customer(final DEVSSimulatorInterface simulator,
			final SellerInterface retailer) throws RemoteException
	{
		super();
		this.simulator = simulator;
		this.retailer = retailer;

		StreamInterface stream = this.simulator.getReplication().getStream(
				"default");
		this.intervalTime = new DistExponential(stream, 0.1);
		this.orderBatchSize = new DistCustom(stream, new DistCustom.Entry[]{
				new DistCustom.Entry(1, 1.0 / 6.0),
				new DistCustom.Entry(2, 1.0 / 3.0),
				new DistCustom.Entry(3, 1.0 / 3.0),
				new DistCustom.Entry(4, 1.0 / 6.0)});
		this.createOrder();
	}

	/**
	 * @see nl.tudelft.simulation.dsol.tutorial.section42.BuyerInterface
	 *      #receiveProduct(long)
	 */
	public void receiveProduct(final long amount)
	{
		Logger.finest(this, "receiveProduct", "received " + amount);
	}

	/**
	 * creates an order
	 */
	private void createOrder()
	{
		this.retailer.order(this, this.orderBatchSize.draw());
		try
		{
			this.simulator
					.scheduleEvent(new SimEvent(this.simulator
							.getSimulatorTime()
							+ this.intervalTime.draw(), this, this,
							"createOrder", null));
		} catch (Exception exception)
		{
			Logger.warning(this, "createOrder", exception);
		}
	}
}