/*
 * @(#) Model.java Dec 8, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section42;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.Persistent;
import nl.tudelft.simulation.dsol.statistics.Tally;
import nl.tudelft.simulation.dsol.statistics.charts.XYChart;

/**
 * A Model <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl"> Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Dec 8, 2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class Model implements ModelInterface
{
	/**
	 * constructs a new Model
	 *  
	 */
	public Model()
	{
		super();
	}

	/**
	 * @see nl.tudelft.simulation.dsol.ModelInterface
	 *      #constructModel(nl.tudelft.simulation.dsol.simulators.SimulatorInterface)
	 */
	public void constructModel(final SimulatorInterface simulator)
			throws RemoteException
	{
		DEVSSimulatorInterface devsSimulator = (DEVSSimulatorInterface) simulator;

		SellerInterface warehouse = new Warehouse(devsSimulator);
		Retailer retailer = new Retailer(devsSimulator, warehouse);
		new Customer(devsSimulator, retailer);

		new Tally("orderingCosts", simulator, retailer,
				Retailer.TOTAL_ORDERING_COST_EVENT);

		Persistent inventory = new Persistent("inventory level", simulator,
				retailer, Retailer.INVENTORY_LEVEL_EVENT);
		Persistent backlog = new Persistent("backlog level", simulator,
				retailer, Retailer.BACKLOG_LEVEL);

		XYChart chart = new XYChart(simulator, "Inventory Levels");
		chart.add(inventory);
		chart.add(backlog);
	}
}