/*
 * @(#) Warehouse.java Dec 8, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section42;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistUniform;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * A Warehouse <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Dec 8, 2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class Warehouse implements SellerInterface
{
	/** simulator. the simulator to schedule on */
	private DEVSSimulatorInterface simulator = null;

	/** the delivery or leadTime */
	private DistContinuous leadTime = null;

	/**
	 * constructs a new Warehouse
	 * 
	 * @param simulator the simulator to schedule on
	 * @throws RemoteException on network failure
	 */
	public Warehouse(final DEVSSimulatorInterface simulator)
			throws RemoteException
	{
		super();
		this.simulator = simulator;

		StreamInterface stream = this.simulator.getReplication().getStream(
				"default");
		this.leadTime = new DistUniform(stream, 0.5, 1.0);
	}

	/**
	 * @see nl.tudelft.simulation.dsol.tutorial.section42.SellerInterface
	 *      #order(nl.tudelft.simulation.dsol.tutorial.section42.BuyerInterface,
	 *      long)
	 */
	public void order(final BuyerInterface buyer, final long amount)
	{
		try
		{
			this.simulator.scheduleEvent(new SimEvent(this.simulator
					.getSimulatorTime()
					+ this.leadTime.draw(), this, buyer, "receiveProduct",
					new Long[]{new Long(amount)}));
		} catch (Exception exception)
		{
			Logger.warning(this, "order", exception);
		}
	}
}