/*
 * @(#) StationaryPolicy.java Dec 8, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section42.policies;

import java.rmi.RemoteException;
import java.util.Properties;

import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;

/**
 * A StationaryPolicy <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Dec 8, 2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class StationaryPolicy implements OrderingPolicy
{
	/** the lower bound of the policy */
	private long lowerBound;

	/** the upper bound of the policy */
	private long upperBound;

	/**
	 * constructs a new StationaryPolicy
	 * 
	 * @param simulator the simulator which is executing the experiment
	 * @throws RemoteException on network failure
	 */
	public StationaryPolicy(final SimulatorInterface simulator)
			throws RemoteException
	{
		super();
		Properties properties = simulator.getReplication().getRunControl()
				.getTreatment().getProperties();

		this.lowerBound = new Long(properties.getProperty("policy.lowerBound"))
				.longValue();
		this.upperBound = new Long(properties.getProperty("policy.upperBound"))
				.longValue();
	}

	/**
	 * @see nl.tudelft.simulation.dsol.tutorial.section42.policies.OrderingPolicy
	 *      #computeAmountToOrder(long)
	 */
	public long computeAmountToOrder(final long inventory)
	{
		if (inventory <= this.lowerBound)
		{
			return this.upperBound - inventory;
		}
		return 0;
	}
}