/*
 * @(#) Life.java Dec 9, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section43;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquationInterface;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.Persistent;
import nl.tudelft.simulation.dsol.statistics.charts.XYChart;

/**
 * A Life <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl"> Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Dec 9, 2003 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class Life implements ModelInterface
{

	/**
	 * constructs a new Life
	 */
	public Life()
	{
		super();
	}

	/**
	 * @see nl.tudelft.simulation.dsol.ModelInterface
	 *      #constructModel(nl.tudelft.simulation.dsol.simulators.SimulatorInterface)
	 */
	public void constructModel(final SimulatorInterface simulator)
			throws RemoteException
	{
		DESSSimulatorInterface dessSimulator = (DESSSimulatorInterface) simulator;

		//Prey and Predator definitions
		Population population = new Population(dessSimulator, 0.1);

		Persistent preyPopulation = new Persistent("prey population",
				dessSimulator, population,
				DifferentialEquationInterface.VALUE_CHANGED_EVENT[0]);

		Persistent predatorPopulation = new Persistent("predator population",
				dessSimulator, population,
				DifferentialEquationInterface.VALUE_CHANGED_EVENT[1]);

		XYChart chart = new XYChart(dessSimulator, "population");
		chart.add(preyPopulation);
		chart.add(predatorPopulation);
	}
}