/*
 * @(#) Population.java Apr 22, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section43;

import java.rmi.RemoteException;
import java.util.Properties;

import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquation;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;

/**
 * The population differential equation.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Apr 22, 2004
 * @since 1.4
 */
public class Population extends DifferentialEquation
{
	/** Lotka-Volterra parameters */
	private double a;

	/** Lotka-Volterra parameters */
	private double b;

	/** Lotka-Volterra parameters */
	private double c;

	/** Lotka-Volterra parameters */
	private double d;

	/**
	 * constructs a new Population
	 * 
	 * @param simulator
	 * @param timeStep
	 * @throws RemoteException on network exception
	 */
	public Population(DESSSimulatorInterface simulator, double timeStep)
			throws RemoteException
	{
		super(simulator, timeStep);
		Properties properties = simulator.getReplication().getRunControl()
				.getTreatment().getProperties();

		double predator = new Double(properties
				.getProperty("predator.initialValue")).doubleValue();
		double prey = new Double(properties.getProperty("prey.initialValue"))
				.doubleValue();
		this.initialize(0.0, new double[]{predator, prey});
		this.a = new Double(properties.getProperty("a")).doubleValue();
		this.b = new Double(properties.getProperty("b")).doubleValue();
		this.c = new Double(properties.getProperty("c")).doubleValue();
		this.d = new Double(properties.getProperty("d")).doubleValue();
	}

	/**
	 * @see nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquationInterface#dy(double,
	 *      double[])
	 */
	public double[] dy(double time, double[] y)
	{
		double[] dy = new double[2];
		dy[0] = -this.a * y[0] + this.b * y[0] * y[1];
		dy[1] = this.c * y[1] - this.d * y[1] * y[0];
		return dy;
	}
}