/*
 * @(#) Ball.java Mar 3, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section44;

import java.rmi.RemoteException;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;

import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;

/**
 * A Ball <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Mar 3, 2004 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public abstract class Ball implements LocatableInterface
{
	/** the number of created balls */
	private static int number = 0;

	/** the radius of the ball */
	public static final double RADIUS = 5.0;

	/** the name of the ball */
	private String name = "";

	/** the origin */
	protected DirectedPoint origin = new DirectedPoint();

	/** the destination */
	protected DirectedPoint destination = new DirectedPoint();

	/** the rotation */
	protected double rotZ = 0.0;

	/**
	 * constructs a new Ball
	 */
	public Ball()
	{
		super();
		this.rotZ = 2 * Math.PI * Math.random();
		Ball.number++;
		this.name = "" + Ball.number;
	}

	/**
	 * @see nl.tudelft.simulation.dsol.animation.LocatableInterface#getBounds()
	 */
	public Bounds getBounds() throws RemoteException
	{
		return new BoundingSphere(new Point3d(0, 0, 0), Ball.RADIUS);
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		return this.name;
	}
}