/*
 * @(#) BallAnimation2D.java Nov 3, 2003
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section44;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.ImageObserver;

import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;

/**
 * The Animation of a Ball.
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Apr 16, 2004
 * @since 1.4
 */
public class BallAnimation2D extends Renderable2D
{
	/**
	 * the color of the ballAnimation
	 */
	private Color color = Color.ORANGE;

	/**
	 * constructs a new BallAnimation2D
	 * 
	 * @param source the source
	 * @param simulator the simulator
	 */
	public BallAnimation2D(final LocatableInterface source,
			final SimulatorInterface simulator)
	{
		super(source, simulator);
	}

	/**
	 * @see nl.tudelft.simulation.dsol.animation.D2.
	 *      Renderable2D#paint(java.awt.Graphics2D,
	 *      java.awt.image.ImageObserver)
	 */
	public void paint(final Graphics2D graphics, final ImageObserver observer)
	{
		graphics.setColor(this.color);
		graphics.fillOval(-(int) Ball.RADIUS, -(int) Ball.RADIUS,
				(int) (Ball.RADIUS * 2.0), (int) (Ball.RADIUS * 2.0));
		graphics.setFont(graphics.getFont().deriveFont(Font.BOLD));
		graphics.setColor(Color.GRAY);
		graphics.drawString(this.source.toString(), (int) (Ball.RADIUS * -1.0),
				(int) (Ball.RADIUS * 1.0));
	}

	/**
	 * @return Returns the color.
	 */
	public Color getColor()
	{
		return this.color;
	}

	/**
	 * @param color The color to set.
	 */
	public void setColor(final Color color)
	{
		this.color = color;
	}
}