/*
 * @(#) Model.java May 10, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section44;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;

/**
 * Model, the ball example in 3D <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 10.05.2004 <br>
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/royc/index.htm">Roy Chin
 *         </a>
 */
public class Model implements ModelInterface
{
	/**
	 * Constructs new Model
	 */
	public Model()
	{
		super();
	}

	/**
	 * @see nl.tudelft.simulation.dsol.ModelInterface#constructModel
	 *      (nl.tudelft.simulation.dsol.simulators.SimulatorInterface)
	 */
	public void constructModel(final SimulatorInterface simulator)
			throws RemoteException, SimRuntimeException
	{
		new World(new DirectedPoint(0, 0, -5.5), simulator);
		for (int i = 0; i < 10; i++)
		{
			new DiscreteBall((DEVSSimulatorInterface) simulator);
			new ContinuousBall((DESSSimulatorInterface) simulator);
		}
	}
}