/*
 * @(#) Positioner.java Mar 3, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section44;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquation;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.logger.Logger;

/**
 * A Positioner <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Mar 3, 2004 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class Positioner extends DifferentialEquation
{
	/**
	 * constructs a new Positioner
	 * 
	 * @param simulator the simulator
	 * @throws RemoteException Exception
	 */
	public Positioner(final DESSSimulatorInterface simulator)
			throws RemoteException
	{
		super(simulator);
		this.initialize(0.0, new double[]{0.0, 0.0});
	}

	/**
	 * sets the value
	 * 
	 * @param value the new value
	 */
	public void setValue(final double value)
	{
		try
		{
			super.initialize(this.simulator.getSimulatorTime(), new double[]{
					value, 0.0});
		} catch (RemoteException exception)
		{
			Logger.warning(this, "setValue", exception);
		}
	}

	/**
	 * @see nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface#dy(double,
	 *      double[])
	 */
	public double[] dy(final double x, final double[] y)
	{
		double[] dy = new double[2];
		dy[0] = y[1]; // v(t) = a(t)
		dy[1] = 0.5; // a(t) = constant
		return dy;
	}
}