/*
 * @(#) Model.java Jan 19, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.dsol.tutorial.section45;

import java.rmi.RemoteException;

import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulator;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.xml.dsol.ExperimentParser;

/**
 * A Model <br>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl"> Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version 1.0 Jan 19, 2004 <br>
 * @author <a href="http://www.simulation.tudelft.nl/people/jacobs.html">Peter
 *         Jacobs </a>
 */
public class Model implements ModelInterface
{
	/**
	 * constructs a new Model
	 *  
	 */
	public Model()
	{
		super();
	}

	/**
	 * @see nl.tudelft.simulation.dsol.ModelInterface
	 *      #constructModel(nl.tudelft.simulation.dsol.simulators.SimulatorInterface)
	 */
	public void constructModel(final SimulatorInterface simulator)
			throws SimRuntimeException, RemoteException
	{
		DEVSSimulatorInterface devsSimulator = (DEVSSimulatorInterface) simulator;
		Port port = new Port(devsSimulator);

		//We schedule boat creation
		this.scheduleBoatArrival(0, devsSimulator, port);
		this.scheduleBoatArrival(1, devsSimulator, port);
		this.scheduleBoatArrival(15, devsSimulator, port);
	}

	/**
	 * schedules the creation of a boat
	 * 
	 * @param time the time when the boat should arrive
	 * @param simulator the simulator on which we schedule
	 * @param port the port
	 * @throws RemoteException on network failuer
	 * @throws SimRuntimeException on simulation exception
	 */
	private void scheduleBoatArrival(final double time,
			final DEVSSimulatorInterface simulator, final Port port)
			throws RemoteException, SimRuntimeException
	{
		simulator.scheduleEvent(new SimEvent(time, this, Boat.class, "<init>",
				new Object[]{simulator, port}));
	}

	/**
	 * commandline executes the model
	 * 
	 * @param args the arguments to the commandline
	 */
	public static void main(final String[] args)
	{
		try
		{
			Experiment experiment = ExperimentParser
					.parseExperiment(URLResource
							.getResource("/nl/tudelft/simulation/examples/dsol/port/experiment.xml"));
			experiment.setSimulator(new DEVSSimulator());
			experiment.start();
		} catch (Exception exception)
		{
			exception.printStackTrace();
		}
	}
}