/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.tutorial.section42;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.tutorial.section42.BuyerInterface;
import nl.tudelft.simulation.dsol.tutorial.section42.SellerInterface;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistCustom;
import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.distributions.DistExponential;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import nl.tudelft.simulation.logger.Logger;

public class Customer
implements BuyerInterface {
    private DEVSSimulatorInterface simulator = null;
    private SellerInterface retailer = null;
    private DistContinuous intervalTime = null;
    private DistDiscrete orderBatchSize = null;

    public Customer(DEVSSimulatorInterface simulator, SellerInterface retailer) throws RemoteException {
        this.simulator = simulator;
        this.retailer = retailer;
        StreamInterface stream = this.simulator.getReplication().getStream("default");
        this.intervalTime = new DistExponential(stream, 0.1);
        this.orderBatchSize = new DistCustom(stream, new DistCustom.Entry[]{new DistCustom.Entry(1L, 0.16666666666666666), new DistCustom.Entry(2L, 0.3333333333333333), new DistCustom.Entry(3L, 0.3333333333333333), new DistCustom.Entry(4L, 0.16666666666666666)});
        this.createOrder();
    }

    public void receiveProduct(long amount) {
        Logger.finest((Object)this, (String)"receiveProduct", (String)("received " + amount));
    }

    private void createOrder() {
        this.retailer.order(this, this.orderBatchSize.draw());
        try {
            this.simulator.scheduleEvent((SimEventInterface)new SimEvent(this.simulator.getSimulatorTime() + this.intervalTime.draw(), (Object)this, (Object)this, "createOrder", null));
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"createOrder", (Throwable)exception);
        }
    }
}

