/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.tutorial.section42;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.Persistent;
import nl.tudelft.simulation.dsol.statistics.Tally;
import nl.tudelft.simulation.dsol.statistics.charts.XYChart;
import nl.tudelft.simulation.dsol.tutorial.section42.Customer;
import nl.tudelft.simulation.dsol.tutorial.section42.Retailer;
import nl.tudelft.simulation.dsol.tutorial.section42.Warehouse;
import nl.tudelft.simulation.event.EventProducerInterface;

public class Model
implements ModelInterface {
    public void constructModel(SimulatorInterface simulator) throws RemoteException {
        DEVSSimulatorInterface devsSimulator = (DEVSSimulatorInterface)simulator;
        Warehouse warehouse = new Warehouse(devsSimulator);
        Retailer retailer = new Retailer(devsSimulator, warehouse);
        new Customer(devsSimulator, retailer);
        new Tally("orderingCosts", simulator, (EventProducerInterface)retailer, Retailer.TOTAL_ORDERING_COST_EVENT);
        Persistent inventory = new Persistent("inventory level", simulator, (EventProducerInterface)retailer, Retailer.INVENTORY_LEVEL_EVENT);
        Persistent backlog = new Persistent("backlog level", simulator, (EventProducerInterface)retailer, Retailer.BACKLOG_LEVEL);
        XYChart chart = new XYChart(simulator, "Inventory Levels");
        chart.add((nl.tudelft.simulation.jstats.statistics.Persistent)inventory);
        chart.add((nl.tudelft.simulation.jstats.statistics.Persistent)backlog);
    }
}

