/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.tutorial.section42;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.tutorial.section42.BuyerInterface;
import nl.tudelft.simulation.dsol.tutorial.section42.SellerInterface;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistUniform;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import nl.tudelft.simulation.logger.Logger;

public class Warehouse
implements SellerInterface {
    private DEVSSimulatorInterface simulator = null;
    private DistContinuous leadTime = null;

    public Warehouse(DEVSSimulatorInterface simulator) throws RemoteException {
        this.simulator = simulator;
        StreamInterface stream = this.simulator.getReplication().getStream("default");
        this.leadTime = new DistUniform(stream, 0.5, 1.0);
    }

    public void order(BuyerInterface buyer, long amount) {
        try {
            this.simulator.scheduleEvent((SimEventInterface)new SimEvent(this.simulator.getSimulatorTime() + this.leadTime.draw(), (Object)this, (Object)buyer, "receiveProduct", (Object[])new Long[]{new Long(amount)}));
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"order", (Throwable)exception);
        }
    }
}

