/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.tutorial.section43;

import java.rmi.RemoteException;
import java.util.Properties;
import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquation;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;

public class Population
extends DifferentialEquation {
    private double a;
    private double b;
    private double c;
    private double d;

    public Population(DESSSimulatorInterface simulator, double timeStep) throws RemoteException {
        super(simulator, timeStep);
        Properties properties = simulator.getReplication().getRunControl().getTreatment().getProperties();
        double predator = new Double(properties.getProperty("predator.initialValue"));
        double prey = new Double(properties.getProperty("prey.initialValue"));
        this.initialize(0.0, new double[]{predator, prey});
        this.a = new Double(properties.getProperty("a"));
        this.b = new Double(properties.getProperty("b"));
        this.c = new Double(properties.getProperty("c"));
        this.d = new Double(properties.getProperty("d"));
    }

    public double[] dy(double time, double[] y) {
        double[] dy = new double[]{-this.a * y[0] + this.b * y[0] * y[1], this.c * y[1] - this.d * y[1] * y[0]};
        return dy;
    }
}

