/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.tutorial.section44;

import java.awt.geom.Point2D;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.tutorial.section44.Ball;
import nl.tudelft.simulation.dsol.tutorial.section44.BallAnimation2D;
import nl.tudelft.simulation.dsol.tutorial.section44.BallAnimation3D;
import nl.tudelft.simulation.dsol.tutorial.section44.Positioner;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;

public class ContinuousBall
extends Ball {
    private Positioner positioner = null;
    private DESSSimulatorInterface simulator = null;

    public ContinuousBall(DESSSimulatorInterface simulator) throws RemoteException {
        this.simulator = simulator;
        this.positioner = new Positioner(simulator);
        new BallAnimation2D(this, (SimulatorInterface)simulator);
        new BallAnimation3D(this, (SimulatorInterface)simulator);
        try {
            this.next();
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"Ball", (Throwable)exception);
        }
    }

    public DirectedPoint getLocation() throws RemoteException {
        double distance = this.positioner.y(this.simulator.getSimulatorTime())[0];
        double x = Math.cos(this.rotZ) * distance + this.origin.x;
        double y = Math.sin(this.rotZ) * distance + this.origin.y;
        if (Math.abs(x - this.origin.x) > Math.abs(this.destination.x - this.origin.x) || Math.abs(y - this.origin.y) > Math.abs(this.destination.y - this.origin.y)) {
            this.next();
        }
        return new DirectedPoint((Point2D)new Point2D.Double(x, y), this.rotZ);
    }

    public void next() throws RemoteException {
        StreamInterface stream = this.simulator.getReplication().getStream("default");
        this.origin = this.destination;
        this.positioner.setValue(0.0);
        this.destination = new DirectedPoint((double)(-100 + stream.nextInt(0, 200)), (double)(-100 + stream.nextInt(0, 200)), 0.0);
        this.rotZ = (this.destination.y - this.origin.y) / (this.destination.x - this.origin.x);
    }
}

