/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.tutorial.section44;

import java.awt.geom.Point2D;
import java.net.URL;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.animation.D2.SingleImageRenderable;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.animation.interpolation.InterpolationInterface;
import nl.tudelft.simulation.dsol.animation.interpolation.LinearInterpolation;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.tutorial.section44.Ball;
import nl.tudelft.simulation.jstats.distributions.DistNormal;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.language.io.URLResource;

public class DiscreteBall
extends Ball {
    private DEVSSimulatorInterface simulator = null;
    private double startTime = Double.NaN;
    private double stopTime = Double.NaN;
    private InterpolationInterface interpolator = null;

    public DiscreteBall(DEVSSimulatorInterface simulator) throws RemoteException, SimRuntimeException {
        this.simulator = simulator;
        URL image = URLResource.getResource((String)"/nl/tudelft/simulation/dsol/tutorial/section44/images/customer.jpg");
        new SingleImageRenderable((LocatableInterface)this, (SimulatorInterface)simulator, image);
        this.next();
    }

    private void next() throws RemoteException, SimRuntimeException {
        StreamInterface stream = this.simulator.getReplication().getStream("default");
        this.origin = this.destination;
        this.rotZ = Math.PI * 2 * Math.random();
        this.destination = new DirectedPoint((Point2D)new Point2D.Double(-100 + stream.nextInt(0, 200), -100 + stream.nextInt(0, 200)), this.rotZ);
        this.startTime = this.simulator.getSimulatorTime();
        this.stopTime = this.startTime + Math.abs(new DistNormal(stream, 9.0, 1.8).draw());
        this.interpolator = new LinearInterpolation(this.startTime, this.stopTime, this.origin, this.destination);
        this.simulator.scheduleEvent((SimEventInterface)new SimEvent(this.stopTime, (Object)this, (Object)this, "next", null));
    }

    public DirectedPoint getLocation() throws RemoteException {
        if (this.interpolator != null) {
            return this.interpolator.getLocation(this.simulator.getSimulatorTime());
        }
        return this.origin;
    }
}

