/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.tutorial.section45;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.formalisms.Resource;
import nl.tudelft.simulation.dsol.formalisms.ResourceRequestorInterface;
import nl.tudelft.simulation.dsol.formalisms.process.Process;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulator;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.tutorial.section45.Port;

public class Boat
extends Process
implements ResourceRequestorInterface {
    private Port port = null;
    private static int number = 1;
    private String description = "Boat(";

    public Boat(DEVSSimulator simulator, Port port) {
        super((DEVSSimulatorInterface)simulator);
        this.port = port;
        this.description = this.description + number++ + ") ";
    }

    public void process() throws SimRuntimeException, RemoteException {
        double startTime = this.simulator.getSimulatorTime();
        this.port.getJetties().requestCapacity(1.0, (ResourceRequestorInterface)this);
        this.suspend();
        this.port.getTugs().requestCapacity(2.0, (ResourceRequestorInterface)this);
        this.suspend();
        this.hold(2.0);
        this.port.getTugs().releaseCapacity(2.0);
        this.hold(14.0);
        this.port.getTugs().requestCapacity(1.0, (ResourceRequestorInterface)this);
        this.suspend();
        this.hold(2.0);
        this.port.getTugs().releaseCapacity(1.0);
        this.port.getJetties().releaseCapacity(1.0);
        System.out.println(this.toString() + "arrived at time=" + startTime + " and left at time=" + this.simulator.getSimulatorTime() + ". ProcessTime = " + (this.simulator.getSimulatorTime() - startTime));
    }

    public void receiveRequestedResource(double requestedCapacity, Resource resource) {
        this.resume();
    }

    public String toString() {
        return this.description;
    }
}

