/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.tutorial.section42;

import java.rmi.RemoteException;
import java.util.Properties;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.tutorial.section42.BuyerInterface;
import nl.tudelft.simulation.dsol.tutorial.section42.SellerInterface;
import nl.tudelft.simulation.dsol.tutorial.section42.policies.OrderingPolicy;
import nl.tudelft.simulation.dsol.tutorial.section42.policies.StationaryPolicy;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.logger.Logger;

public class Retailer
extends EventProducer
implements BuyerInterface,
SellerInterface {
    public static final EventType TOTAL_ORDERING_COST_EVENT = new EventType("TOTAL_ORDERING_COST_EVENT");
    public static final EventType INVENTORY_LEVEL_EVENT = new EventType("INVENTORY_LEVEL_EVENT");
    public static final EventType BACKLOG_LEVEL = new EventType("BACKLOG_LEVEL");
    private long inventory = 60L;
    private long backLog = 0L;
    private DEVSSimulatorInterface simulator = null;
    private SellerInterface warehouse = null;
    private OrderingPolicy orderingPolicy = null;
    private double backlogCosts;
    private double holdingCosts;
    private double marginalCosts;
    private double setupCosts;

    public Retailer(DEVSSimulatorInterface simulator, SellerInterface warehouse) throws RemoteException {
        this.simulator = simulator;
        this.warehouse = warehouse;
        this.orderingPolicy = new StationaryPolicy((SimulatorInterface)simulator);
        Properties properties = this.simulator.getReplication().getRunControl().getTreatment().getProperties();
        this.backlogCosts = new Double(properties.getProperty("retailer.costs.setup"));
        this.holdingCosts = new Double(properties.getProperty("retailer.costs.holding"));
        this.marginalCosts = new Double(properties.getProperty("retailer.costs.marginal"));
        this.setupCosts = new Double(properties.getProperty("retailer.costs.setup"));
        this.reviewInventory();
    }

    public void receiveProduct(long amount) {
        long served = this.backLog - Math.max(0L, this.backLog - amount);
        this.backLog = Math.max(0L, this.backLog - amount);
        this.inventory += Math.max(0L, amount - served);
        try {
            this.fireEvent(INVENTORY_LEVEL_EVENT, this.inventory, this.simulator.getSimulatorTime());
            this.fireEvent(BACKLOG_LEVEL, this.backLog, this.simulator.getSimulatorTime());
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"receiveProduct", (Throwable)exception);
        }
    }

    private void reviewInventory() {
        double costs = this.holdingCosts * (double)this.inventory + this.backlogCosts * (double)this.backLog;
        long amount = this.orderingPolicy.computeAmountToOrder(this.inventory);
        if (amount > 0L) {
            costs = costs + this.setupCosts + (double)amount * this.marginalCosts;
            this.fireEvent(TOTAL_ORDERING_COST_EVENT, costs);
            this.warehouse.order(this, amount);
        }
        try {
            this.simulator.scheduleEvent((SimEventInterface)new SimEvent(this.simulator.getSimulatorTime() + 1.0, (Object)this, (Object)this, "reviewInventory", null));
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"reviewInventory", (Throwable)exception);
        }
    }

    public void order(BuyerInterface buyer, long amount) {
        long actualOrderSize = Math.min(amount, this.inventory);
        this.inventory -= actualOrderSize;
        if (actualOrderSize < amount) {
            this.backLog += amount - actualOrderSize;
        }
        try {
            this.fireEvent(INVENTORY_LEVEL_EVENT, this.inventory, this.simulator.getSimulatorTime());
            this.fireEvent(BACKLOG_LEVEL, this.backLog, this.simulator.getSimulatorTime());
        }
        catch (RemoteException exception) {
            Logger.warning((Object)this, (String)"receiveProduct", (Throwable)exception);
        }
        buyer.receiveProduct(actualOrderSize);
    }
}

