/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.tutorial.section42.policies;

import java.rmi.RemoteException;
import java.util.Properties;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.tutorial.section42.policies.OrderingPolicy;

public class StationaryPolicy
implements OrderingPolicy {
    private long lowerBound;
    private long upperBound;

    public StationaryPolicy(SimulatorInterface simulator) throws RemoteException {
        Properties properties = simulator.getReplication().getRunControl().getTreatment().getProperties();
        this.lowerBound = new Long(properties.getProperty("policy.lowerBound"));
        this.upperBound = new Long(properties.getProperty("policy.upperBound"));
    }

    public long computeAmountToOrder(long inventory) {
        if (inventory <= this.lowerBound) {
            return this.upperBound - inventory;
        }
        return 0L;
    }
}

