/*
 * @(#)DistributionParser.java Jun 25, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.xml.jstats;

import java.io.IOException;
import java.net.URL;

import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.jstats.distributions.Dist;
import nl.tudelft.simulation.jstats.distributions.DistBernoulli;
import nl.tudelft.simulation.jstats.distributions.DistBeta;
import nl.tudelft.simulation.jstats.distributions.DistBinomial;
import nl.tudelft.simulation.jstats.distributions.DistConstant;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.distributions.DistExponential;
import nl.tudelft.simulation.jstats.distributions.DistNormal;
import nl.tudelft.simulation.jstats.distributions.DistTriangular;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

import org.jdom.Element;

/**
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Jun 25, 2004 <br>
 * @author <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public final class DistributionParserOld
{
	/** the default schema file */
	public static final URL DISTRIBUTIONFILE_SCHEMA = DistributionParser.class
			.getResource("/nl/tudelft/simulation/xml/jstats/distribution.xsd");

	/**
	 * constructs a new DistributionParserOld
	 */
	private DistributionParserOld()
	{
		super();
		//unreachable code
	}

	/**
	 * parses a xml-element representing a distribution function
	 * 
	 * @param element The j-dom element
	 * @param simulator the simulator to use
	 * @return the distribution function
	 * @throws IOException on failure
	 */
	public static DistContinuous parseContinuousDistribution(
			final Element element, final SimulatorInterface simulator)
			throws IOException
	{
		try
		{
			String streamId = element.getAttributeValue("stream");
			StreamInterface stream = simulator.getReplication().getStream(
					streamId);
			if (element.getChild("beta") != null)
			{
				Element distribution = element.getChild("beta");
				double alpha1 = new Double(distribution
						.getAttributeValue("alpha1")).doubleValue();
				double alpha2 = new Double(distribution
						.getAttributeValue("alpha2")).doubleValue();
				return new DistBeta(stream, alpha1, alpha2);
			} else if (element.getChild("triangular") != null)
			{
				Element distribution = element.getChild("triangular");
				double a = new Double(distribution.getAttributeValue("a"))
						.doubleValue();
				double b = new Double(distribution.getAttributeValue("b"))
						.doubleValue();
				double c = new Double(distribution.getAttributeValue("c"))
						.doubleValue();
				return new DistTriangular(stream, a, b, c);
			} else if (element.getChild("normal") != null)
			{
				Element distribution = element.getChild("normal");
				double mean = new Double(distribution.getAttributeValue("mean"))
						.doubleValue();
				double stdev = new Double(distribution
						.getAttributeValue("stdev")).doubleValue();
				return new DistNormal(stream, mean, stdev);
			} else if (element.getChild("exponential") != null)
			{
				Element distribution = element.getChild("exponential");
				double lambda = new Double(distribution
						.getAttributeValue("lambda")).doubleValue();
				return new DistExponential(stream, lambda);
			} else if (element.getChild("constant") != null)
			{
				Element distribution = element.getChild("constant");
				double c = new Double(distribution.getAttributeValue("c"))
						.doubleValue();
				return new DistConstant(stream, c);
			} else
			{
				throw new Exception("Unknown distribution in "
						+ element.getName());
			}
		} catch (Exception exception)
		{
			throw new IOException(exception.getMessage());
		}
	}

	/**
	 * parses a xml-element representing a distribution function
	 * 
	 * @param element The j-dom element
	 * @param simulator the simulator to use
	 * @return the distribution function
	 * @throws IOException on failure
	 */
	public static DistDiscrete parseDiscreteDistribution(final Element element,
			final SimulatorInterface simulator) throws IOException
	{
		try
		{
			String streamId = element.getAttributeValue("stream");
			StreamInterface stream = simulator.getReplication().getStream(
					streamId);
			if (element.getChild("bernoulli") != null)
			{
				Element distribution = element.getChild("bernoulli");
				double p = new Double(distribution.getAttributeValue("p"))
						.doubleValue();
				return new DistBernoulli(stream, p);
			} else if (element.getChild("binomial") != null)
			{
				Element distribution = element.getChild("binomial");
				long n = new Long(distribution.getAttributeValue("n"))
						.longValue();
				double p = new Double(distribution.getAttributeValue("p"))
						.doubleValue();
				return new DistBinomial(stream, n, p);
			} else
			{
				throw new Exception("Unknown distribution in "
						+ element.getName());
			}
		} catch (Exception exception)
		{
			throw new IOException(exception.getMessage());
		}
	}

	/**
	 * @param element the element to parse
	 * @param simulator the simulator
	 * @return the parsed distribution
	 * @throws IOException on failure
	 */
	public static Dist parseDistribution(final Element element,
			final SimulatorInterface simulator) throws IOException
	{
		try
		{
			if (element.getChild("bernoulli") != null)
			{
				return DistributionParser.parseDiscreteDistribution(element,
						simulator);
			} else if (element.getChild("beta") != null)
			{
				return DistributionParser.parseContinuousDistribution(element,
						simulator);
			} else if (element.getChild("binomial") != null)
			{
				return DistributionParser.parseDiscreteDistribution(element,
						simulator);
			} else if (element.getChild("triangular") != null)
			{
				return DistributionParser.parseContinuousDistribution(element,
						simulator);
			} else
			{
				throw new Exception("Unknown distribution in "
						+ element.getName());
			}
		} catch (Exception exception)
		{
			throw new IOException(exception.getMessage());
		}
	}
}