/*
 * @(#)DistributionParser.java Jun 25, 2004
 * 
 * Copyright (c) 2003, 2004 Delft University of Technology Jaffalaan 5, 2628 BX
 * Delft, the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */

package nl.tudelft.simulation.xml.language;

import java.io.IOException;
import java.net.URL;

import nl.tudelft.simulation.language.d3.DirectedPoint;

import org.jdom.Element;

/**
 * <br>
 * (c) copyright 2003-2004 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a href="http://www.simulation.tudelft.nl">
 * www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @version Jun 25, 2004 <br>
 * @author <a
 *         href="http://www.tbm.tudelft.nl/webstaf/alexandv/index.htm">Alexander
 *         Verbraeck </a>
 */
public final class LocationParser
{
	/** the default schema file */
	public static final URL LOCATIONFILE_SCHEMA = LocationParser.class
			.getResource("/nl/tudelft/simulation/xml/xsd/location.xsd");

	/**
	 * constructs a new LocationParser
	 */
	private LocationParser()
	{
		super();
		// unreachable code
	}

	/**
	 * parses a xml-element representing a DirectedPoint
	 * 
	 * @param element The j-dom element
	 * @return DirectedPoint of element
	 * @throws IOException on IOfailure
	 */
	public static DirectedPoint parseLocation(final Element element)
			throws IOException
	{
		try
		{
			double x = new Double(element.getAttributeValue("x")).doubleValue();
			double y = new Double(element.getAttributeValue("y")).doubleValue();
			double z = 0.0;
			if (element.getAttributeValue("z") != null)
			{
				z = new Double(element.getAttributeValue("z")).doubleValue();
			}
			double phi = 0.0;
			if (element.getAttributeValue("phi") != null)
			{
				phi = new Double(element.getAttributeValue("phi"))
						.doubleValue();
			}
			double rho = 0.0;
			if (element.getAttributeValue("rho") != null)
			{
				rho = new Double(element.getAttributeValue("rho"))
						.doubleValue();
			}
			double theta = 0.0;
			if (element.getAttributeValue("theta") != null)
			{
				theta = new Double(element.getAttributeValue("theta"))
						.doubleValue();
			}
			return new DirectedPoint(x, y, z, phi, rho, theta);
		} catch (Exception exception)
		{
			throw new IOException("element: " + element + "\nattributes: "
					+ element.getAttributes() + "\nchaildren: "
					+ element.getChildren() + "\nmessage: "
					+ exception.getMessage());
		}
	}
}