/*
 * @(#) ExperimentParserTest.java Sep 28, 2004
 * 
 * Copyright (c) 2003 Delft University of Technology Jaffalaan 5, 2628 BX Delft,
 * the Netherlands All rights reserved.
 * 
 * This software is proprietary information of Delft University of Technology
 * The code is published under the General Public License
 */
package nl.tudelft.simulation.xml;

import java.net.URL;

import junit.framework.TestCase;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.xml.dsol.ExperimentParser;

/**
 * <p>
 * (c) copyright 2003 <a href="http://www.simulation.tudelft.nl">Delft
 * University of Technology </a>, the Netherlands. <br>
 * See for project information <a
 * href="http://www.simulation.tudelft.nl">www.simulation.tudelft.nl </a> <br>
 * License of use: <a href="http://www.gnu.org/copyleft/gpl.html">General Public
 * License (GPL) </a>, no warranty <br>
 * 
 * @author <a href="http://www.tbm.tudelft.nl/webstaf/peterja/index.htm">Peter
 *         Jacobs </a>
 * @version 1.2 Sep 28, 2004
 * @since 1.4
 */
public class ExperimentParserTest extends TestCase
{

	/**
	 * constructs a new ExperimentParserTest
	 */
	public ExperimentParserTest()
	{
		this("test");
	}

	/**
	 * constructs a new ExperimentParserTest
	 * 
	 * @param arg0
	 */
	public ExperimentParserTest(String arg0)
	{
		super(arg0);
	}

	/**
	 * tests the experiment test
	 */
	public void test()
	{
		URL url = URLResource
				.getResource("/DummyExperiment.xml");
		System.out.println(url);
		try
		{
			ExperimentParser.parseExperiment(url);
		} catch (Exception exception)
		{
			exception.printStackTrace();
		}
	}
}