/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.xml.dsol;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import nl.tudelft.simulation.dsol.ModelInterface;
import nl.tudelft.simulation.dsol.experiment.Experiment;
import nl.tudelft.simulation.dsol.experiment.ExperimentalFrame;
import nl.tudelft.simulation.dsol.experiment.Replication;
import nl.tudelft.simulation.dsol.experiment.TimeUnitInterface;
import nl.tudelft.simulation.dsol.experiment.Treatment;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.jstats.streams.MersenneTwister;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.logger.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ExperimentParser {
    private static SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);

    protected ExperimentParser() {
    }

    public static ExperimentalFrame parseExperimentalFrame(URL input) throws IOException {
        try {
            return ExperimentParser.parseExperimentalFrame(new InitialContext(), input);
        }
        catch (NamingException exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public static ExperimentalFrame parseExperimentalFrame(Context context, URL input) throws IOException {
        if (input == null) {
            throw new IOException("experiment URL=null");
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            String name = DateFormat.getDateTimeInstance().format(calendar.getTime());
            Context root = context.createSubcontext(name);
            Element rootElement = builder.build(input).getRootElement();
            ArrayList<Experiment> experiments = new ArrayList<Experiment>();
            List experimentElements = rootElement.getChildren("experiment");
            int number = 0;
            for (Element element : experimentElements) {
                Context experimentContext = root.createSubcontext("experiment[" + number + "]");
                Experiment experiment = ExperimentParser.parseExperiment(experimentContext, element, input);
                experiment.setDescription("experiment " + number);
                experiments.add(experiment);
                ++number;
            }
            ExperimentalFrame frame = new ExperimentalFrame(root, input);
            frame.setExperiments(experiments);
            return frame;
        }
        catch (Exception exception) {
            Logger.warning(ExperimentParser.class, (String)"parseExperimentalFrame", (Throwable)exception);
            return null;
        }
    }

    public static Experiment parseExperiment(Context context, Element rootElement, URL url) throws IOException {
        try {
            ClassLoader loader = ExperimentParser.resolveClassLoader(url);
            Experiment experiment = new Experiment(context);
            Element modelElement = rootElement.getChild("model");
            if (modelElement.getChild("class-path") != null) {
                List jarFiles = modelElement.getChild("class-path").getChildren("jar-file");
                URL[] urls = new URL[jarFiles.size()];
                int nr = 0;
                for (Element child : jarFiles) {
                    urls[nr] = URLResource.getResource((String)child.getValue());
                    ++nr;
                }
                loader = new URLClassLoader(urls, loader);
            }
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> modelClass = Class.forName(modelElement.getChildText("model-class"), true, loader);
            ModelInterface model = (ModelInterface)ClassUtil.resolveConstructor(modelClass, null).newInstance(new Object[0]);
            experiment.setModel(model);
            Treatment treatment = ExperimentParser.parseTreatment(rootElement.getChild("treatment"), experiment, context);
            experiment.setTreatment(treatment);
            Class<?> simulatorClass = Class.forName(rootElement.getChildText("simulator-class"), true, loader);
            SimulatorInterface simulator = (SimulatorInterface)ClassUtil.resolveConstructor(simulatorClass, null).newInstance(new Object[0]);
            experiment.setSimulator(simulator);
            return experiment;
        }
        catch (Exception exception) {
            Logger.warning(ExperimentParser.class, (String)"parseExperiment", (Throwable)exception);
            throw new IOException(exception.getMessage());
        }
    }

    private static ClassLoader resolveClassLoader(URL input) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (input.getProtocol().equals("file")) {
            try {
                ArrayList<URL> urls = new ArrayList<URL>();
                String path = input.getPath().substring(0, input.getPath().lastIndexOf(47)) + "/";
                urls.add(new URL("file:" + path));
                if (path.endsWith("src/")) {
                    path = path.substring(0, path.length() - 4) + "bin/";
                    urls.add(new URL("file:" + path));
                } else {
                    path = path.substring(0, path.length()) + "bin/";
                    urls.add(new URL("file:" + path));
                }
                URL[] urlArray = urls.toArray(new URL[urls.size()]);
                URLClassLoader urlClassLoader = new URLClassLoader(urlArray, loader);
                return urlClassLoader;
            }
            catch (MalformedURLException exception) {
                return loader;
            }
        }
        return loader;
    }

    private static long parseDateTime(String value) {
        Calendar calendar = Calendar.getInstance();
        String concatDate = value.split("T")[0];
        String concatTime = value.split("T")[1];
        String[] date = concatDate.split("-");
        String[] time = concatTime.split(":");
        calendar.set(new Integer(date[0]), new Integer(date[1]) - 1, new Integer(date[2]), new Integer(time[0]), new Integer(time[1]), new Integer(time[2]));
        return calendar.getTimeInMillis();
    }

    private static double parsePeriod(Element element, TimeUnitInterface treatmentTimeUnit) throws Exception {
        TimeUnitInterface timeUnit = ExperimentParser.parseTimeUnit(element.getAttribute("unit").getValue());
        double value = -1.0;
        value = element.getText().equals("INF") ? Double.MAX_VALUE : new Double(element.getText());
        if (value < 0.0) {
            throw new JDOMException("parsePeriod: value = " + value + " <0. simulator cannot schedule in past");
        }
        return (double)timeUnit.getValue() * value / (double)treatmentTimeUnit.getValue();
    }

    private static Replication parseReplication(Element element, Treatment parent, Context context) throws Exception {
        Replication replication = new Replication(context, parent);
        if (element.getAttribute("description") != null) {
            replication.setDescription(element.getAttribute("description").getValue());
        }
        HashMap<String, MersenneTwister> streams = new HashMap<String, MersenneTwister>();
        List streamElements = element.getChildren("stream");
        for (Element streamElement : streamElements) {
            long seed = new Long(streamElement.getAttributeValue("seed"));
            MersenneTwister stream = new MersenneTwister(seed);
            streams.put(streamElement.getAttributeValue("name"), stream);
        }
        replication.setStreams(streams);
        return replication;
    }

    private static Properties parseProperties(Element element) {
        Properties result = new Properties();
        List children = element.getChildren("property");
        for (Element child : children) {
            String key = child.getAttributeValue("key");
            String value = child.getAttributeValue("value");
            result.put(key, value);
        }
        return result;
    }

    private static TimeUnitInterface parseTimeUnit(String name) throws Exception {
        if (name.equals("DAY")) {
            return TimeUnitInterface.DAY;
        }
        if (name.equals("HOUR")) {
            return TimeUnitInterface.HOUR;
        }
        if (name.equals("MILLISECOND")) {
            return TimeUnitInterface.MILLISECOND;
        }
        if (name.equals("MINUTE")) {
            return TimeUnitInterface.MINUTE;
        }
        if (name.equals("SECOND")) {
            return TimeUnitInterface.SECOND;
        }
        if (name.equals("WEEK")) {
            return TimeUnitInterface.WEEK;
        }
        if (name.equals("UNIT")) {
            return TimeUnitInterface.UNIT;
        }
        throw new Exception("parseTimeUnit.. unknown argument: " + name);
    }

    private static Treatment parseTreatment(Element element, Experiment parent, Context context) throws Exception {
        Treatment treatment = new Treatment(parent);
        treatment.setTimeUnit(ExperimentParser.parseTimeUnit(element.getChildText("timeUnit")));
        if (element.getChild("startTime") != null) {
            treatment.setStartTime(ExperimentParser.parseDateTime(element.getChildText("startTime")));
        }
        if (element.getChild("warmupPeriod") != null) {
            treatment.setWarmupPeriod(ExperimentParser.parsePeriod(element.getChild("warmupPeriod"), treatment.getTimeUnit()));
        }
        if (element.getChild("runLength") != null) {
            treatment.setRunLength(ExperimentParser.parsePeriod(element.getChild("runLength"), treatment.getTimeUnit()));
        }
        List replicationElements = element.getChildren("replication");
        ArrayList<Replication> replicationArray = new ArrayList<Replication>();
        int number = 1;
        Iterator i = replicationElements.iterator();
        while (i.hasNext()) {
            replicationArray.add(ExperimentParser.parseReplication((Element)i.next(), treatment, context));
            ++number;
        }
        treatment.setReplications(replicationArray);
        if (element.getChild("properties") != null) {
            treatment.setProperties(ExperimentParser.parseProperties(element.getChild("properties")));
        }
        return treatment;
    }

    static {
        builder.setFeature("http://xml.org/sax/features/validation", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        String xsd = URLResource.getResource((String)"/xsd/experiment.xsd").toExternalForm();
        builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://www.simulation.tudelft.nl " + xsd));
    }
}

